% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-manipulation.R
\name{ms_rotate_map}
\alias{ms_rotate_map}
\title{Rotate maps}
\usage{
ms_rotate_map(map_original, map_modified, rotation = 0, apply_rotation = FALSE)
}
\arguments{
\item{map_original}{File name of the original map without anything drawn over
it (either a \code{.pdf} or \code{.png}; extension will be ignored).}

\item{map_modified}{File name of the modified version with drawings (either a
\code{.pdf} or \code{.png}; extension will be ignored).}

\item{rotation}{Rotation value to be applied, generally +/- 90}

\item{apply_rotation}{If \code{FALSE}, display results of rotation without
actually applying it; otherwise transform the specified \code{map_modified} image
according to the specified rotation.}
}
\value{
No return value. Function either modifies files on disk by rotating
images by the specified amount (if \code{apply_rotation = TRUE}), or displays a
rotated version of \code{map_original} (if \code{apply_rotation = FALSE}).
}
\description{
Display original and modified maps to determine necessary rotation
}
\note{
If a call to \link{ms_rectify_map} detects potential image rotation,
that function will stop and suggest that rotation be applied using this
function in order to determine the required degree of image rotation. Values
for \code{rotation} can be trialled in order to determine the correct value,
following which that value can be entered with \code{apply_rotation = TRUE} in
order to actually apply that rotation to the modified image.
}
