% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baskin_robbins.R
\name{create_clusterball_mapper_object}
\alias{create_clusterball_mapper_object}
\title{Run clusterball mapper}
\usage{
create_clusterball_mapper_object(
  data,
  dist1,
  dist2,
  eps,
  clusterer = hierarchical_clusterer("single")
)
}
\arguments{
\item{data}{A data frame.}

\item{dist1}{A distance matrix for the data frame; this will be used to ball the data.}

\item{dist2}{Another distance matrix for the data frame; this will be used to cluster the data after balling.}

\item{eps}{A positive real number for your desired ball radius.}

\item{clusterer}{A function which accepts a list of distance matrices as input, and returns the results of clustering done on each distance matrix.}
}
\value{
A list of two dataframes, one with node data containing bin membership,
datapoints per cluster, and cluster dispersion, and one with edge data
containing sources, targets, and weights representing overlap strength.
}
\description{
Run ball mapper, but additionally cluster within the balls. Can use two different distance matrices to accomplish this.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
data.dists = dist(data)
eps = 1

create_clusterball_mapper_object(data, data.dists, data.dists, eps)
}
