% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_precipitation_chirps.R
\name{precipitation_chirps}
\alias{precipitation_chirps}
\alias{calc_precipitation_chirps}
\title{Calculate precipitation sums based on CHIRPS}
\usage{
calc_precipitation_chirps(years = 1981:2020, engine = "extract")
}
\arguments{
\item{years}{A numeric vector indicating the years for which to calculate
precipitation statistics.}

\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
\value{
A function that returns a tibble with precipitation sums.
}
\description{
This functions allows to calculate precipitation sums based on the
CHIRPS rainfall estimates. Corresponding to the time-frame of the analysis
of the portfolio, monthly precipitation sums are calculated.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{chirps}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_chirps(years = 2010)) \%>\%
  calc_indicators(
    calc_precipitation_chirps(
      years = 2010,
      engine = "extract"
    )
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
