% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\name{interpolate}
\alias{interpolate}
\title{Create an interpolation expression}
\usage{
interpolate(
  column = NULL,
  property = NULL,
  type = "linear",
  values,
  stops,
  na_color = NULL
)
}
\arguments{
\item{column}{The name of the column to use for the interpolation. If specified, \code{property} should be NULL.}

\item{property}{The name of the property to use for the interpolation. If specified, \code{column} should be NULL.}

\item{type}{The interpolation type. Can be one of \code{"linear"}, \code{c("exponential", base)} where \code{base} specifies the rate at which the output increases, or \code{c("cubic-bezier", x1, y1, x2, y2)} where you define a cubic bezier curve with control points.}

\item{values}{A numeric vector of values at which stops occur.}

\item{stops}{A vector of corresponding stops (colors, sizes, etc.) for the interpolation.}

\item{na_color}{The color to use for missing values.  Mapbox GL JS defaults to black if this is not supplied.}
}
\value{
A list representing the interpolation expression.
}
\description{
This function generates an interpolation expression that can be used to style your data.
}
\examples{
interpolate(
  column = "estimate",
  type = "linear",
  values = c(1000, 200000),
  stops = c("#eff3ff", "#08519c")
)
}
