% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weiszfeld.R
\name{weiszfeld}
\alias{weiszfeld}
\title{Weiszfeld Algorithm for Computing L1-median}
\usage{
weiszfeld(X, weights = NULL, maxiter = 496, abstol = 1e-06)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix for \eqn{p}-dimensional signal. If vector is given, it is assumed that \eqn{p=1}.}

\item{weights}{\code{NULL} for equal weight \code{rep(1/n,n)}; otherwise, it has to be a vector of length \eqn{n}.}

\item{maxiter}{maximum number of iterations.}

\item{abstol}{stopping criterion}
}
\description{
Geometric median, also known as L1-median, is a solution to the following problem
\deqn{\textrm{argmin} \sum_{i=1}^n \| x_i - y \|_2 }
for a given data \eqn{x_1,x_2,\ldots,x_n \in R^p}.
}
\examples{
## generate sin(x) data with noise for 100 replicates
set.seed(496)
t = seq(from=0,to=10,length.out=20)
X = array(0,c(100,20))
for (i in 1:100){
   X[i,] = sin(t) + stats::rnorm(20, sd=0.5)
}

## compute L1-median and L2-mean
vecL2 = base::colMeans(X)
vecL1 = weiszfeld(X)

## visualize
opar <- par(mfrow=c(1,3), no.readonly=TRUE, pty="s")
matplot(t(X[1:5,]), type="l", main="5 generated data", ylim=c(-2,2))
plot(t, vecL2, type="l", col="blue", main="L2-mean",   ylim=c(-2,2))
plot(t, vecL1, type="l", col="red",  main="L1-median", ylim=c(-2,2))
par(opar)

}
