% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyapunov.R
\name{lyapunov}
\alias{lyapunov}
\title{Solve Lyapunov Equation}
\usage{
lyapunov(A, Q)
}
\arguments{
\item{A}{a \eqn{(p\times p)} matrix as above.}

\item{Q}{a \eqn{(p\times p)} matrix as above.}
}
\value{
a solution matrix \eqn{X} of size \eqn{(p\times p)}.
}
\description{
The Lyapunov equation is of form
\deqn{AX + XA^\top = Q}
where \eqn{A} and \eqn{Q} are square matrices of same size. Above form is also known as \emph{continuous} form. 
This is a wrapper of \code{armadillo}'s \code{sylvester} function.
}
\examples{
## simulated example
#  generate square matrices
A = matrix(rnorm(25),nrow=5)
X = matrix(rnorm(25),nrow=5)
Q = A\%*\%X + X\%*\%t(A)

#  solve using 'lyapunov' function
solX = lyapunov(A,Q)
pm1 = "* Experiment with Lyapunov Solver"
pm2 = paste("* Absolute Error  : ",norm(solX-X,"f"),sep="")
pm3 = paste("* Relative Error  : ",norm(solX-X,"f")/norm(X,"f"),sep="")
cat(paste(pm1,"\n",pm2,"\n",pm3,sep=""))

}
\references{
\insertRef{sanderson_armadillo:_2016}{maotai}

\insertRef{eddelbuettel_rcpparmadillo:_2014}{maotai}
}
