% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_read.R
\name{read}
\alias{read}
\alias{read_matrix}
\alias{write_matrix}
\alias{read_edgelist}
\alias{write_edgelist}
\alias{read_nodelist}
\alias{write_nodelist}
\alias{read_pajek}
\alias{write_pajek}
\alias{read_ucinet}
\alias{write_ucinet}
\alias{read_dynetml}
\title{Make networks from/to external formats}
\source{
\code{read_ucinet()} and \code{write_ucinet()} kindly supplied by Christian Steglich,
constructed on 18 June 2015.
}
\usage{
read_matrix(file = file.choose(), sv = c("comma", "semi-colon"), ...)

write_matrix(.data, filename, name, ...)

read_edgelist(file = file.choose(), sv = c("comma", "semi-colon"), ...)

write_edgelist(.data, filename, name, ...)

read_nodelist(file = file.choose(), sv = c("comma", "semi-colon"), ...)

write_nodelist(.data, filename, name, ...)

read_pajek(file = file.choose(), ties = NULL, ...)

write_pajek(.data, filename, ...)

read_ucinet(file = file.choose())

write_ucinet(.data, filename, name)

read_dynetml(file = file.choose())
}
\arguments{
\item{file}{A character string with the system path to the file to import.
If left unspecified, an OS-specific file picker is opened to help users select it.
Note that in \code{read_ucinet()} the file path should be to the header file (.##h),
if it exists and that it is currently not possible to import multiple
networks from a single UCINET file. Please convert these one by one.}

\item{sv}{Allows users to specify whether their csv file is
\code{"comma"} (English) or \code{"semi-colon"} (European) separated.}

\item{...}{Additional parameters passed to the read/write function.}

\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{filename}{UCINET filename (without ## extension).
By default the files will have the same name as the object
and be saved to the working directory.}

\item{name}{name of matrix to be known in UCINET.
By default the name will be the same as the object.}

\item{ties}{Where there are}
}
\value{
\code{read_edgelist()} and \code{read_nodelist()} will import
into edgelist (tibble) format which can then be coerced or combined into
different graph objects from there.

\code{read_pajek()} and \code{read_ucinet()} will import into
a tidygraph format, since they already contain both edge and attribute data.
\code{read_matrix()} will import into tidygraph format too.
Note that all graphs can be easily coerced into other formats
with \code{{manynet}}'s \code{as_} methods.

The \code{write_}functions export to different file formats,
depending on the function.

A pair of UCINET files in V6404 file format (.##h, .##d)
}
\description{
Researchers regularly need to work with a variety of external data formats.
The following functions offer ways to import from some common external
file formats into objects that \code{{manynet}} and other graph/network packages
in R can work with.

Note that these functions are not as actively maintained as others
in the package, so please let us know if any are not currently working
for you or if there are missing import routines
by \href{https://github.com/snlab-ch/manynet/issues}{raising an issue on Github}.
}
\details{
There are a number of repositories for network data
that hold various datasets in different formats. See for example:
\itemize{
\item \href{https://sites.google.com/site/ucinetsoftware/datasets?authuser=0}{UCINET data}
\item \href{http://vlado.fmf.uni-lj.si/pub/networks/data/}{Pajek data}
}

See also:
\itemize{
\item \href{https://schochastics.github.io/networkdata/}{networkdata}
\item \href{http://www-personal.umich.edu/~mejn/netdata/}{GML datasets}
\item UCIrvine Network Data Repository
\item \href{http://konect.cc/}{KONECT project}
\item \href{http://snap.stanford.edu/data/}{SNAP Stanford Large Network Dataset Collection}
}

Please let us know if you identify any further repositories
of social or political networks and we would be happy to add them here.

The \verb{_ucinet} functions only work with relatively recent UCINET
file formats, e.g. type 6406 files.
To import earlier UCINET file types, you will need to update them first.
To import multiple matrices packed into a single UCINET file,
you will need to unpack them and convert them one by one.
}
\section{Functions}{
\itemize{
\item \code{read_matrix()}: Reading adjacency matrices from Excel/csv files

\item \code{write_matrix()}: Writing matrix to csv files

\item \code{read_edgelist()}: Reading edgelists from Excel/csv files

\item \code{write_edgelist()}: Writing edgelists to csv files

\item \code{read_nodelist()}: Reading nodelists from Excel/csv files

\item \code{write_nodelist()}: Writing nodelists to csv files

\item \code{read_pajek()}: Reading pajek (.net/.paj) files

\item \code{write_pajek()}: Writing pajek .net files

\item \code{read_ucinet()}: Reading UCINET files

\item \code{write_ucinet()}: Writing UCINET files

\item \code{read_dynetml()}: Reading DynetML files

}}
\seealso{
\link{as}

Other makes: 
\code{\link{as}()},
\code{\link{create}},
\code{\link{generate}}
}
\concept{makes}
