% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_miss.R
\name{miss}
\alias{miss}
\alias{na_to_zero}
\alias{na_to_mean}
\title{Tools for imputing missing tie data}
\usage{
na_to_zero(.data)

na_to_mean(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
A data object of the same class as the function was given.
}
\description{
These functions offer tools for imputing missing tie data.
Currently two options are available:
replacing the missing values with zeros,
which are the modal value in sparse social networks,
and replacing the missing values with the average non-missing value for that vector.
}
\section{Functions}{
\itemize{
\item \code{na_to_zero()}: Impute missing tie data as zero,
the modal value in sparse social networks.

\item \code{na_to_mean()}: Impute missing tie data as
the mean value in the network.

}}
\examples{
missTest <- ison_adolescents \%>\% 
   add_tie_attribute("weight", c(1,NA,NA,1,1,1,NA,NA,1,1)) \%>\% 
   as_matrix
missTest
na_to_zero(missTest)
na_to_mean(missTest)
}
\references{
Krause, Robert, Mark Huisman, Christian Steglich, and Tom A.B. Snijders. 2020.
"Missing data in cross-sectional networks–An extensive comparison of missing data treatment methods".
\emph{Social Networks}, 62, 99-112.
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{from}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{tidy}},
\code{\link{transform}()}
}
\concept{manipulations}
