% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_general.R
\name{scale_weighted}
\alias{scale_bipolar}
\alias{scale_logit}
\alias{scale_ratio}
\alias{scale_weighted}
\title{Scaling functions}
\usage{
scale_weighted(data, vars = grep("per((\\\\d{3}(_\\\\d)?)|\\\\d{4}|(uncod))$",
  names(data), value = TRUE), weights = 1)

scale_logit(data, pos, neg, N = data[, "total"], zero_offset = 0.5, ...)

scale_bipolar(data, pos, neg, ...)

scale_ratio(data, pos, neg, ...)
}
\arguments{
\item{data}{A data.frame with cases to be scaled}

\item{vars}{variable names that should contribute to the linear combination;
defaults to all CMP category percentage variables in the Manifesto Project's Main Dataset}

\item{weights}{weights of the linear combination in the same order as `vars`.}

\item{pos}{variable names that should contribute to the numerator ("positively")}

\item{neg}{variable names that should contribute to the denominator ("negatively")}

\item{N}{vector of numbers of quasi sentences to convert percentages to counts}

\item{zero_offset}{Constant to be added to prevent 0/0 and log(0); defaults to 0.5 (smaller than any possible non-zero count)}

\item{...}{further parameters passed on to \code{\link{scale_weighted}}}
}
\description{
Scaling functions take a data.frame of variables with information about
political parties/text and position the cases on a scale, i.e. output a
vector of values. For applying scaling functions directly to text documents,
refer to \code{\link{mp_scale}}.

\code{scale_logit} scales the data on a logit scale as described by Lowe et al. (2011).

\code{scale_bipolar} scales the data by adding up the variable
values in pos and substracting the variable values in neg.

\code{scale_ratio} scales the data taking the ratio of the sum of the variable
values in pos and the sum of the variable values in neg as suggested by Kim and Fording (1998) and by Laver & Garry (2000).
}
\details{
\code{scale_weighted} scales the data as a weighted sum of the variable values


If variable names used for the definition of the scale
are not present in the data frame they are assumed to be 0.
\code{scale_weighted} scales the data as a weighted sum of the category percentages
}
\references{
Lowe, W., Benoit, K., Mikhaylov, S., & Laver, M. (2011). Scaling Policy Preferences from Coded Political Texts. Legislative Studies Quarterly, 36(1), 123-155.

Kim, H., & Fording, R. C. (1998). Voter ideology in western democracies, 1946-1989. European Journal of Political Research, 33(1), 73-97.

Laver, M., & Garry, J. (2000). Estimating Policy Positions from Political Texts. American Journal of Political Science, 44(3), 619-634.
}
\seealso{
\code{\link{mp_scale}}
}

