% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{plot_posterior_variance}
\alias{plot_posterior_variance}
\alias{plot_posterior_stdev}
\alias{plot_posterior_precision}
\title{Plotting posterior variances, standard deviations or precisions}
\usage{
plot_posterior_variance(obj)

plot_posterior_stdev(obj)

plot_posterior_precision(obj)
}
\arguments{
\item{obj}{An object from \code{inference_stan} or \code{inference_inla}.}
}
\value{
A \link[ggplot2]{ggplot} object with the plot
See also \link[makemyprior]{makemyprior_plotting}.
}
\description{
Plotting posterior variances, standard deviations or precisions
}
\examples{
\dontrun{

ex_prior <- makemyprior_example_model()
res_stan <- inference_stan(ex_prior)
res_inla <- inference_inla(ex_prior)
plot_posterior_variance(res_stan)
plot_posterior_variance(res_inla)

}

}
\keyword{plot}
