% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{latin_data}
\alias{latin_data}
\title{Latin square experiment data}
\format{
A list with the following variables:
\describe{
  \item{y}{Response}
  \item{lin}{Covariate for linear effect of treatment}
  \item{row}{Row indexes}
  \item{col}{Column indexes}
  \item{treat_iid, treat_rw2}{Treatment indexes}
}
}
\usage{
latin_data
}
\description{
Simulated dataset for latin square experiment with 81 observations.
}
\examples{
\dontrun{

vignette("latin_square", package = "makemyprior")

formula <- y ~ lin + mc(row) + mc(col) + mc(iid) +
mc(rw2, model = "rw2", constr = TRUE, lin_constr = TRUE)

prior <- make_prior(
  formula, latin_data,
  prior = list(tree = "s1 = (rw2, iid);
                               s2 = (row, col, s1); s3 = (s2, eps)",
               w = list(s1 = list(prior = "pc0", param = 0.25),
                        s2 = list(prior = "dirichlet"),
                        s3 = list(prior = "pc0", param = 0.25))))

posterior <- inference_stan(prior, iter = 15000, warmup = 5000,
                            seed = 1, init = "0", chains = 1)

plot(prior)
plot_tree_structure(prior)
plot_posterior_fixed(posterior)
plot_posterior_stan(posterior, param = "prior", prior = TRUE)
}
}
\keyword{datasets}
