% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduleTaskList.R
\name{scheduleTaskList}
\alias{scheduleTaskList}
\title{Minimize Expression Start Time}
\usage{
scheduleTaskList(graph, maxWorker = 2L, exprTime = NULL,
  exprTimeDefault = 1e-05, sizeDefault = as.numeric(utils::object.size(1L)),
  overhead = 8e-06, bandwidth = 1.5e+09)
}
\arguments{
\item{graph}{object of class \code{DependGraph} as returned from \code{\link{inferGraph}}}

\item{maxWorker}{integer maximum number of processors}

\item{exprTime}{time in seconds to execute each expression}

\item{exprTimeDefault}{numeric time in seconds to execute a single
expression. This will only be used if \code{exprTime} is NULL.}

\item{sizeDefault}{numeric default size of objects to transfer in bytes}

\item{overhead}{numeric seconds to send any object}

\item{bandwidth}{numeric speed that the network can transfer an object
between processors in bytes per second. We don't take network
contention into account. This will have to be extended to account for
multiple machines.}
}
\value{
schedule object of class \code{TaskSchedule}
}
\description{
Implementation of "list scheduling".
This is a greedy algorithm that assigns each expression to the earliest
possible processor.
}
\details{
This function is experimental and unstable. If you're trying to actually
speed up your code through parallelism then consider using the default
method in \code{\link{schedule}} for data parallelism.
This function rewrites code to use task parallelism.
Task parallelism means two or more processors run different R
expressions simultaneously.
}
\examples{
code <- parse(text = "a <- 100
     b <- 200
     c <- a + b")

g <- inferGraph(code)
s <- scheduleTaskList(g)
plot(s)
}
\references{
Algorithm 10 in \emph{Task Scheduling for Parallel
Systems}, Sinnen (2007)
}
