% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fx.R
\name{fx}
\alias{fx}
\alias{image_fx}
\title{Image FX}
\usage{
image_fx(image, expression = "p", channel = NULL)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{expression}{string with an \href{https://www.imagemagick.org/script/fx.php}{fx expression}}

\item{channel}{a value of \code{\link[=channel_types]{channel_types()}} specifying which channel(s) to set}
}
\description{
Apply a custom an \href{https://www.imagemagick.org/script/fx.php}{fx expression} to the image.
}
\examples{
# Show image_fx() expression
img <- image_convert(logo, colorspace = "Gray")
image_fx(img, expression = "pow(p, 0.5)")
image_fx(img, expression = "random()")

gradient_x <- image_convolve(img, kernel = "Prewitt")
gradient_y <- image_convolve(img, kernel = "Prewitt:90")
gradient <- c(image_fx(gradient_x, expression = "p^2"),
                image_fx(gradient_y, expression = "p^2"))
gradient <- image_flatten(gradient, operator = "Plus")
gradient <- image_fx(gradient, expression = "sqrt(p)")
gradient
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{edges}},
  \code{\link{editing}}, \code{\link{effects}},
  \code{\link{geometry}}, \code{\link{morphology}},
  \code{\link{ocr}}, \code{\link{options}},
  \code{\link{painting}}, \code{\link{segmentation}},
  \code{\link{transform}}, \code{\link{video}}
}
\concept{image}
