% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divide_by_quantile.R
\name{divide_by_quantile}
\alias{divide_by_quantile}
\title{Divide variable based on quantiles}
\usage{
divide_by_quantile(data, n, na.rm = TRUE)
}
\arguments{
\item{data}{A numeric vector.}

\item{n}{An integer specifying the number of levels in the factor to be
created.}

\item{na.rm}{A logical vector indicating whether the \code{NA} values should
be removed before the quantiles are computed.}
}
\value{
A vector of class \code{factor} indicating in which quantile the
element in \code{data} belongs.
}
\description{
Creates a factor based on equally spaced quantiles of a variable.
}
\examples{
x <- c(sample(1:20, 9), NA)
divide_by_quantile(x, 3)
}
\seealso{
\code{\link[stats:quantile]{stats::quantile()}}.
}
