% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abort.R
\name{abort_argument}
\alias{abort_argument}
\alias{abort_argument_type}
\alias{abort_argument_class}
\alias{abort_argument_length}
\alias{abort_argument_diff_length}
\alias{abort_argument_value}
\title{Abort based on issues with function argument}
\usage{
abort_argument_type(arg, must, not)

abort_argument_class(arg, must, not)

abort_argument_length(arg, must, not)

abort_argument_diff_length(arg1, arg2)

abort_argument_value(arg, valid_values)
}
\arguments{
\item{arg}{A character string with the argument name.}

\item{must}{A character string specifying a condition the argument must
fulfill.}

\item{not}{Either a character string specifying a condition the argument
must not fulfill or the bare (unquoted) argument name. In the last case,
the function evaluates the argument type (\code{abort_argument_type()}) or
length (\code{abort_argument_length()}) and displays the result in the
error message.}

\item{arg1, arg2}{A character string with the argument name.}

\item{valid_values}{A character vector with the valid values.}
}
\value{
Each function returns a classed error condition.
\code{abort_argument_type()} returns a \code{error_argument_type} class,
\code{abort_argument_length()} returns a \code{error_argument_length}
class, \code{abort_argument_diff_length()} returns a
\code{error_argument_diff_length} class and \code{abort_argument_value()}
returns a \code{error_argument_value} class.
}
\description{
Create a custom error condition created with
\code{\link[rlang:abort]{rlang::abort()}} with a - hopefully - more useful
error message and metadata.
}
\seealso{
\code{\link[=abort_column_not_found]{abort_column_not_found()}},
\code{\link[=abort_no_method_for_class]{abort_no_method_for_class()}}
}
