% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lift.R
\name{lift}
\alias{lift}
\title{Lift}
\usage{
lift(x, pdGH = 21)
}
\arguments{
\item{x}{object of class \code{mlta}}

\item{pdGH}{number of quadrature points for the Gauss-Hermite quadrature. Default \code{pdGH = 21}}
}
\value{
The function returns an (\code{M} x \code{M} x \code{D}) array.
}
\description{
The lift can be used to analyse the dependence within each groups found using the function \code{\link{mlta}}.The lift can be used to quantify the effect of the dependence on the probability of a sender nodes being liked to two receivers within each group compared to the probability of being liked to two receivers under an independence model. Two independent links to the receiver nodes have lift = 1: the more the links to receiver nodes are dependent, the further the value of the lift is from 1.
}
\examples{
### Simulate Bipartite Network
set.seed(1)
X <- matrix(rbinom(4 * 12, size = 1, prob = 0.4), nrow = 12, ncol = 4)
res <- mlta(X, G = 2, D = 1)
res_lift <- lift(res)
}
\references{
Gollini, I. (in press) 'A mixture model approach for clustering bipartite networks', Challenges in Social Network Research Volume in the Lecture Notes in Social Networks (LNSN - Series of Springer). Preprint: \url{https://arxiv.org/abs/1905.02659}.

Gollini, I., and Murphy, T. B. (2014), 'Mixture of Latent Trait Analyzers for Model-Based Clustering of Categorical Data', Statistics and Computing, 24(4), 569-588 \url{http://arxiv.org/abs/1301.2167}.
}
\seealso{
\code{\link{mlta}}
}
