% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lua_func.R
\name{lua_func}
\alias{lua_func}
\title{Make a Lua function callable from R}
\usage{
lua_func(func, argcode = "s", L = NULL)
}
\arguments{
\item{func}{Lua expression evaluating to a function.}

\item{argcode}{How to wrap R arguments for the Lua function.}

\item{L}{\link[=lua_open]{Lua state} in which to run the code. \code{NULL} (default)
uses the default Lua state for \pkg{luajr}.}
}
\value{
An R function which can be called to invoke the Lua function.
}
\description{
Takes any Lua expression that evaluates to a function and provides an R
function that can be called to invoke the Lua function.
}
\details{
The R types that can be passed to Lua are: \code{NULL}, logical vector,
integer vector, numeric vector, string vector, list, and external pointer.

The parameter \code{argcode} is a string with one character for each argument of
the Lua function, recycled as needed (e.g. so that a single character would
apply to all arguments regardless of how many there are).

In the following, the corresponding character of \code{argcode} for a specific
argument is referred to as its argcode.

For \code{NULL} or any argument with length 0, the result in Lua is \strong{nil}
regardless of the corresponding argcode.

For logical, integer, double, and character vectors, if the corresponding
argcode is \code{'s'} (simplify), then if the R vector has length one, it is
supplied as a Lua primitive (boolean, number, number, or string,
respectively), and if length > 1, as an array, i.e. a table with integer
indices starting at 1. If the code is \code{'a'}, the vector is always supplied as
an array, even if it only has length 1. If the argcode is the digit \code{'1'}
through \code{'9'}, this is the same as \code{'s'}, but the vector is required to have
that specific length, otherwise an error message is emitted.

Still focusing on vectors, if the argcode is \code{'r'}, then the vector is
passed \emph{by reference} to Lua, adopting the type \code{luajr.logical_r},
\code{luajr.integer_r}, \code{luajr.numeric_r}, or \code{luajr.character_r} as appropriate.
If the argcode is \code{'v'}, the vector is passed \emph{by value} to Lua,
adopting the type \code{luajr.logical}, \code{luajr.integer}, \code{luajr.numeric}, or
\code{luajr.character} as appropriate.

For lists, if the argcode is \code{'s'} (simplify), the list is passed as a Lua
table. Any entries of the list with non-blank names are named in the table,
while unnamed entries have the associated integer key in the table. Note that
Lua does not preserve the order of entries in tables. This means that an R
list with names will often go "out of order" when passed into Lua with \code{'s'}
and then returned back to R. This is avoided with argcode \code{'r'} or \code{'v'}.

If a list is passed in with the argcode \code{'r'} or \code{'v'}, the list is
passed to Lua as type \code{luajr.list}, and all vector elements of the list are
passed by reference or by value, respectively.

For external pointers, the argcode is ignored and the external pointer is
passed to Lua as type \strong{userdata}.

When the function is called and Lua values are returned from the function,
the Lua return values are converted to R values as follows.

If nothing is returned, the function returns invisible() (i.e. NULL).

If multiple arguments are returned, a list with all arguments is returned.

Reference types (e.g. \code{luajr.logical_r}) and vector types (e.g.
\code{luajr.logical}) are returned to R as such. A \code{luajr.list} is returned as an
R list. Reference and list types respect R attributes set within Lua code.

A \strong{table} is returned as a list. In the list, any table entries with a
number key come first (with indices 1 to n, i.e. the original number key's
value is discarded), followed by any table entries with a string key
(named accordingly). This may well scramble the order of keys, so beware.
Note in particular that Lua does not guarantee that it will traverse a table
in ascending order of keys. Entries with non-number, non-string keys are
discarded. It is probably best to avoid returning a \strong{table} with anything
other than string keys, or to use \code{luajr.list}.
}
\examples{
squared <- lua_func("function(x) return x^2 end")
print(squared(7))
}
