# Runs the function multicompLetters from the multcompView package
# returns an error if not installed
.mcletters = function(..., Letters=c("1234567890",LETTERS,letters)) {
    if(!requireNamespace("multcompView", quietly = TRUE))
        stop("The 'multcompView' package must be installed to use cld methods")
    
    # Expand strings to individual letters
    Letters = as.character(unlist(sapply(Letters, function(stg) {
        sapply(seq_len(nchar(stg)), function(i) substr(stg, i, i))
    })))
    
    result = multcompView::multcompLetters(..., Letters=Letters)
    if (is.null(result$monospacedLetters))
        result$monospacedLetters = result$Letters
    result
}

# If multcomp not installed, define my own generic for cld
# (It is exported in the NAMESPACE file under the same cond)
if(!requireNamespace("multcomp", quietly = TRUE)) {
    
    cld <- function(object, ...)
        UseMethod("cld")
    
}

# S3 method for lsmobj
cld.lsmobj = function(object, details=FALSE, sort=TRUE, by, alpha=.05, 
                      Letters = c("1234567890",LETTERS,letters), ...) {
    lsmtbl = summary(object, ...)
    if(missing(by)) 
        by = object@misc$by.vars
    if (sort) {
        args = list()
        for (nm in by) args[[nm]] = lsmtbl[[nm]]
        args$.lsm. = lsmtbl[[object@misc$estName]]
        ord = do.call("order", args)
        lsmtbl = lsmtbl[ord, ]
        object@grid = object@grid[ord, , drop=FALSE]
        object@linfct = object@linfct[ord, , drop = FALSE]
    }
    attr(lsmtbl, "by.vars") = by
    object@misc$by.vars = by
    
    prwise = contrast(object, "revpairwise", by=by)    
    pwtbl = test(prwise, ...)
    
    p.boo = (pwtbl$p.value < alpha)
    if(is.null(by)) {
        by.rows = list(seq_len(nrow(pwtbl)))
        by.out = list(seq_len(nrow(lsmtbl)))
    }
    else {
        by.rows = .find.by.rows(pwtbl, by)
        by.out = .find.by.rows(lsmtbl, by)
    }
    # Create comps matrix reflecting order generated by pairwise.lsmc
    icol = jcol = numeric(0)
    # create fake row indexes in revpairwise order for use by .mcletters
    k = length(by.out[[1]])
    for (i in 2:k) {
        icol = c(icol, seq_len(i-1))
        jcol = c(jcol, rep(i, i-1))
    }
    labs = paste(icol,jcol,sep="-")
    ltrs = rep("", nrow(lsmtbl))
    for (i in seq_len(length(by.rows))) {
        pb = p.boo[by.rows[[i]]]
        names(pb) = labs
        mcl = .mcletters(pb, Letters=Letters)
        ltrs[by.out[[i]]] = paste(" ", mcl$monospacedLetters, sep="")
    }
    lsmtbl[[".group"]] = ltrs
    
    attr(lsmtbl, "mesg") = c(attr(lsmtbl,"mesg"), attr(pwtbl, "mesg"), 
                             paste("significance level used: alpha =", alpha))
        
    if (details)
        list(lsmeans = lsmtbl, comparisons = pwtbl)
    else
        lsmtbl
}


# ### Some code originally contributed by Luciano Selzer
# ### Needs to be made more robust
# #
# # NOTE - not in build yet: Need to modify .Rbuildignore to incorporate this
# 
# ### Russ's start at a fcn that works with multcomp
# ### Need Torsten to agree to export insert_absorb()
# .get.cld <- function(diffs, level=.05, nsets = 1, rev = FALSE) {
#     # diffs -- results from lsmeans with a pairwise or revpairwise formula
#     # level -- cutoff sig level
#     # nsets -- number of contrast sets (in a conditional spec)
#     # rev -- FALSE for pairwise and TRUE for reversepairwise
#     x = matrix((diffs$p.value < level), ncol = nsets)
#     k = (sqrt(1 + 8*nrow(x)) + 1) / 2
# 
#     # Create comps matrix reflecting order generated by pairwise.lsmc
#     icol = jcol = numeric(0)
#     for (i in 1:(k-1)) {
#         icol = c(icol, rep(i, k-i))
#         jcol = c(jcol, (i+1):k)
#     }
#     comps = cbind(icol, jcol)
#     if(rev) # change to revpairwise.lsmc order
#         comps = comps[order(jcol,icol), 2:1]
#         
#     ltrs = character(0)
#     ltr.pool = c(LETTERS, letters)
#     for (j in 1:ncol(x)) {
#         IA = .insert_absorb(x[,j], Letters=ltr.pool, comps=comps, lvl_order=1:k)
#         if (j > 1) {
#             pad = substr("                               ", 1, ncol(IA$LetterMatrix))
#             ltrs = sapply(ltrs, paste, pad, sep="")
#         }
#         ltrs = c(ltrs, IA$monospacedLetters)
#         ltr.pool = setdiff(ltr.pool, dimnames(IA$LetterMatrix)[[2]])
#     }
#     ltrs
# }
# 
# 
# # my own copy of code from multcomp, for now
# 
# .insert_absorb <- function (x, Letters = c(letters, LETTERS), separator = ".", 
#                            decreasing = FALSE, comps = NULL, lvl_order) 
# {
#     obj_x <- deparse(substitute(x))
#     if (is.null(comps)) {
#         namx <- names(x)
#         #namx <- gsub(" ", "", names(x))
#         if (length(namx) != length(x)) 
#             stop("Names required for ", obj_x)
#         split_names <- strsplit(namx, "-")
#         stopifnot(sapply(split_names, length) == 2)
#         comps <- t(as.matrix(as.data.frame(split_names)))
#     }
#     rownames(comps) <- names(x)
#     lvls <- lvl_order
#     n <- length(lvls)
#     lmat <- array(TRUE, dim = c(n, 1), dimnames = list(lvls, 
#                                                        NULL))
#     if (sum(x) == 0) {
#         ltrs <- rep(.get_letters(1, Letters = Letters, separator = separator), 
#                     length(lvls))
#         names(ltrs) <- lvls
#         colnames(lmat) <- ltrs[1]
#         msl <- ltrs
#         ret <- list(Letters = ltrs, monospacedLetters = msl, 
#                     LetterMatrix = lmat)
#         class(ret) <- "multcompLetters"
#         return(ret)
#     }
#     else {
#         signifs <- comps[x, , drop = FALSE]
#         absorb <- function(m) {
#             for (j in 1:(ncol(m) - 1)) {
#                 for (k in (j + 1):ncol(m)) {
#                     if (all(m[which(m[, k]), k] & m[which(m[, k]), 
#                                                     j])) {
#                         m <- m[, -k, drop = FALSE]
#                         return(absorb(m))
#                     }
#                     else if (all(m[which(m[, j]), k] & m[which(m[, 
#                                                                  j]), j])) {
#                         m <- m[, -j, drop = FALSE]
#                         return(absorb(m))
#                     }
#                 }
#             }
#             return(m)
#         }
#         for (i in 1:nrow(signifs)) {
#             tmpcomp <- signifs[i, ]
#             wassert <- which(lmat[tmpcomp[1], ] & lmat[tmpcomp[2], 
#                                                        ])
#             if (any(wassert)) {
#                 tmpcols <- lmat[, wassert, drop = FALSE]
#                 tmpcols[tmpcomp[2], ] <- FALSE
#                 lmat[tmpcomp[1], wassert] <- FALSE
#                 lmat <- cbind(lmat, tmpcols)
#                 colnames(lmat) <- .get_letters(ncol(lmat), Letters = Letters, 
#                                               separator = separator)
#                 if (ncol(lmat) > 1) {
#                     lmat <- absorb(lmat)
#                     colnames(lmat) <- .get_letters(ncol(lmat), Letters = Letters, 
#                                                   separator = separator)
#                 }
#             }
#         }
#     }
#     lmat <- lmat[, order(apply(lmat, 2, sum))]
#     lmat <- .sweepLetters(lmat)
#     lmat <- lmat[, names(sort(apply(lmat, 2, function(x) return(min(which(x))))))]
#     colnames(lmat) <- .get_letters(ncol(lmat), Letters = Letters, 
#                                   separator = separator)
#     lmat <- lmat[, order(apply(lmat, 2, sum))]
#     lmat <- .sweepLetters(lmat)
#     
#     lmat <- lmat[, names(sort(apply(lmat, 2, function(x) return(min(which(x)))), 
#                               decreasing = decreasing))]
#     colnames(lmat) <- .get_letters(ncol(lmat), Letters = Letters, 
#                                   separator = separator)
#     ltrs <- apply(lmat, 1, function(x) return(paste(names(x)[which(x)], 
#                                                     sep = "", collapse = "")))
#     msl <- matrix(ncol = ncol(lmat), nrow = nrow(lmat))
#     for (i in 1:nrow(lmat)) {
#         msl[i, which(lmat[i, ])] <- colnames(lmat)[which(lmat[i, 
#                                                               ])]
#         absent <- which(!lmat[i, ])
#         if (length(absent) < 2) {
#             if (length(absent) == 0) 
#                 next
#             else {
#                 msl[i, absent] <- paste(rep(" ", nchar(colnames(lmat)[absent])), 
#                                         collapse = "")
#             }
#         }
#         else {
#             msl[i, absent] <- unlist(lapply(sapply(nchar(colnames(lmat)[absent]), 
#                                                    function(x) return(rep(" ", x))), paste, collapse = ""))
#         }
#     }
#     msl <- apply(msl, 1, paste, collapse = "")
#     names(msl) <- rownames(lmat)
#     ret <- list(Letters = ltrs, monospacedLetters = msl, LetterMatrix = lmat, 
#                 aLetters = Letters, aseparator = separator)
#     class(ret) <- "multcompLetters"
#     return(ret)
# }
# 
# .get_letters <- function (n, Letters = c(letters, LETTERS), separator = ".") 
# {
#     n.complete <- floor(n/length(Letters))
#     n.partial <- n%%length(Letters)
#     lett <- character()
#     separ = ""
#     if (n.complete > 0) {
#         for (i in 1:n.complete) {
#             lett <- c(lett, paste(separ, Letters, sep = ""))
#             separ <- paste(separ, separator, sep = "")
#         }
#     }
#     if (n.partial > 0) 
#         lett <- c(lett, paste(separ, Letters[1:n.partial], sep = ""))
#     return(lett)
# }
# 
# .sweepLetters <- function (mat, start.col = 1, Letters = c(letters, LETTERS), 
#           separator = ".") 
# {
#     stopifnot(all(start.col %in% 1:ncol(mat)))
#     locked <- matrix(rep(0, ncol(mat) * nrow(mat)), ncol = ncol(mat))
#     cols <- 1:ncol(mat)
#     cols <- cols[c(start.col, cols[-start.col])]
#     if (any(is.na(cols))) 
#         cols <- cols[-which(is.na(cols))]
#     for (i in cols) {
#         tmp <- matrix(rep(0, ncol(mat) * nrow(mat)), ncol = ncol(mat))
#         tmp[which(mat[, i]), ] <- mat[which(mat[, i]), ]
#         one <- which(tmp[, i] == 1)
#         if (all(apply(tmp[, -i, drop = FALSE], 1, function(x) return(any(x == 
#                                                                              1))))) {
#             next
#         }
#         for (j in one) {
#             if (locked[j, i] == 1) {
#                 next
#             }
#             chck <- 0
#             lck <- list()
#             for (k in one) {
#                 if (j == k) {
#                     next
#                 }
#                 else {
#                     rows <- tmp[c(j, k), ]
#                     dbl <- rows[1, ] & rows[2, ]
#                     hit <- which(dbl)
#                     hit <- hit[-which(hit == i)]
#                     dbl <- rows[1, -i, drop = FALSE] & rows[2, 
#                                                             -i, drop = FALSE]
#                     if (any(dbl)) {
#                         chck <- chck + 1
#                         lck[[chck]] <- list(c(j, hit[length(hit)]), 
#                                             c(k, hit[length(hit)]))
#                     }
#                 }
#             }
#             if ((chck == (length(one) - 1)) && chck != 0) {
#                 for (k in 1:length(lck)) {
#                     locked[lck[[k]][[1]][1], lck[[k]][[1]][2]] <- 1
#                     locked[lck[[k]][[2]][1], lck[[k]][[2]][2]] <- 1
#                 }
#                 mat[j, i] <- FALSE
#             }
#         }
#         if (all(mat[, i] == FALSE)) {
#             mat <- mat[, -i, drop = FALSE]
#             colnames(mat) <- .get_letters(ncol(mat), Letters = Letters, 
#                                          separator = separator)
#             return(.sweepLetters(mat, Letters = Letters, separator = separator))
#         }
#     }
#     onlyF <- apply(mat, 2, function(x) return(all(!x)))
#     if (any(onlyF)) {
#         mat <- mat[, -which(onlyF), drop = FALSE]
#         colnames(mat) <- .get_letters(ncol(mat), Letters = Letters, 
#                                      separator = separator)
#     }
#     return(mat)
# }






### The rest of this I'm omitting ###

# cld <- function (object, ...) {
#     UseMethod("cld")
# }
# 
# cld.lsm <- function(object, reversed = FALSE, omitNotSig  = FALSE){
#     if (!require(multcompView) || !require(reshape2))
#         stop("'cld' requires the 'multcompView' and 'reshape2' packages")
#     #Extract pValues and actual Values
#     pValues <- extract_p(object)
#     values <- extract_values.lsm(object)
#     if(is.list(pValues)) {
#         # I need to do this to order the levels of according to their mean
#         # Otherwise the letters end up mixed
#         pValues <- lapply(seq_along(pValues), 
#                           function(i) order_p(pValues[[i]], values[[i]]))
#         letters <- laply(pValues, wrapLetters, reversed, omitNotSig)
#         letters <- melt(letters)
#         # Make the order of the levels match those of values data.frame
#         letters$Var2 <- factor(letters$Var2, levels = levels(values[[1]][,1]))
#         # Order again, otherwise the letters do not match the actual values
#         letters <- letters[order(letters[,1], letters[,2]), 3]
#     }else {
#         pvalues <- order_p(pValues, values)
#         letters <- wrapLetters(pValues, reversed = reversed, 
#                                omitNotSig = omitNotSig)
#     }
#     # old behaviour of returning a data.frame
#     ans <- cbind(object[[1]], letters)
#     ans
# }
# 
# extract_p.lsm <- function(x){
#     x <- x[[2]]
#     ans <- x[,5]
#     names(ans) <- gsub(" ", "", row.names(x))
#     if(any(grepl("\\|", names(ans)))) {
#         s <- do.call(rbind, strsplit(names(ans), split= "\\|"))
#         names(ans) <- s[,1]
#         # I need the split factor ordered by appearence in the original data.frame
#         # It would mix levels of the spliting factor if left to default. 
#         # Althougth not everytime.
#         f <- factor(s[,2], levels = unique(s[,2]))
#         ans <- split(ans, f)
#     }
#     ans
# }
# 
# extract_values.lsm <- function(x){
#     x <- x[[1]]
#     levels(x[, 1]) <- gsub(" ", "", levels(x[,1]))
#     # Check if there's a split factor and split if it's there
#     if(which(names(x) == "lsmean") == 3) {
#         ans <- split(x, x[,2])
#     }else ans <- x
#     ans
# }
# 
# order_p <- function(pValues, x){
#     # Order the pValues according to their level's mean
#     oz <- order(x[,"lsmean"], decreasing = FALSE)
#     Lvls <- levels(x[[1]])[oz]
#     value <- vec2mat(pValues)
#     value <- value[Lvls, Lvls]
#     value
# }
# 
# wrapLetters <- function(x, reversed = FALSE, omitNotSig = FALSE){
#     x <- multcompLetters(x, reversed = reversed)[[1]]
#     if(omitNotSig){
#         if(all(x == x[1])) {
#             x[seq_along(x)] <- rep("", length(x))
#             
#         }
#     }
#     # Make the order of all the results the same.
#     # Because lapply would just rbind the vector together regardless the name
#     x <- x[order(names(x))]
#     x
# }