% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.lsirm.R
\name{diagnostic.lsirm}
\alias{diagnostic.lsirm}
\title{Diagnostic the result of LSIRM model}
\usage{
diagnostic.lsirm(
  object,
  plot = TRUE,
  draw.item = list(beta = "first", theta = "first", alpha = "second"),
  which.draw = c("beta", "gamma"),
  plot.roc = T
)
}
\arguments{
\item{object}{object of class \code{lsirm}.}

\item{plot}{If \code{TRUE}, MCMC diagnostic plots are returned}

\item{draw.item}{Select items for diagnosis. A default "first" is drawing the first item for selected parameters in \code{which.draw}. Parameter "alpha", however, uses "second" as a default value because the first alpha has an estimation issue. Positions and item names are supported. For instance, if the name of item is "i1", "i2", "i3" and its positions is in order, the result of \code{beta = c("i1","i2","i3")} and \code{beta = c(1,2,3)} are equivalent.}

\item{which.draw}{Select parameters for diagnosis. For the 1PL model, "beta", "theta" and "gamma" are available. "alpha" is only available in the 2PL model.}

\item{plot.roc}{If \code{TRUE}, ROC curve and AUC value are returned. This option is only available when input data type is binary.}
}
\value{
\code{diagnostic.lsirm} returns plots for checking MCMC convergence for selected parameters. In binary cases, ROC curve and AUC are supported.
}
\description{
\code{diagnostic.lsirm} is used to diagnostic the result of LSIRM model.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5), ncol=10, nrow=50)
lsirm_result <- lsirm(data ~ lsirm1pl(spikenslab = FALSE, fixed_gamma = FALSE))

# 1PL model
diagnostic.lsirm(lsirm_result, plot=TRUE,
                 which.draw=c("beta","theta","gamma"), plot.roc = TRUE)

# 1PL model, multiple items
diagnostic.lsirm(lsirm_result, plot=TRUE, draw.item=list(beta = c(1,2,3)),
                 which.draw=c("beta", "gamma"), plot.roc = TRUE)

lsirm_result <- lsirm(data ~ lsirm2pl(spikenslab = FALSE, fixed_gamma = FALSE))

# 2PL model
diagnostic.lsirm(lsirm_result, plot=TRUE,
                 which.draw=c("beta", "theta", "alpha", "gamma"), plot.roc = TRUE)
}
}
