% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsgl.R
\docType{package}
\name{lsgl-package}
\alias{lsgl-package}
\title{Linear Multiple Output Using Sparse Group Lasso.}
\description{
Simultaneous feature selection and parameter estimation for linear multiple output.
The algorithm finds the sparse group lasso penalized maximum likelihood estimator.
This result in feature and parameter selection, and parameter estimation.
Use of parallel computing for cross validation and subsampling is supported through the 'foreach' and 'doParallel' packages.
}
\details{
The sparse gorup lasso linear mltiple output estimator is defined as
\deqn{\frac{1}{N}\|Y-X\beta\|_F^2 + \lambda \left( (1-\alpha) \sum_{J=1}^m \gamma_J \|\beta^{(J)}\|_2 + \alpha \sum_{i=1}^{n} \xi_i |\beta_i| \right)}
where \eqn{\|\cdot\|_F} is the frobenius norm.
The vector \eqn{\beta^{(J)}} denotes the parameters associated with the \eqn{J}'th group of features.
The group weights are denoted by \eqn{\gamma \in [0,\infty)^m} and the parameter weights by \eqn{\xi \in [0,\infty)^n}.
}
\examples{
# NOTE
}
\author{
Martin Vincent \email{martin.vincent.dk@gmail.com}
}

