% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.int.lsbclust.R
\name{plot.int.lsbclust}
\alias{plot.int.lsbclust}
\title{Plot Method for Class 'int.lsbclust'}
\usage{
\method{plot}{int.lsbclust}(x, which = seq_len(nclust),
  plot.type = c("biplots", "means", "estimates"), segments = NULL,
  biplot.axes = FALSE, nmarkers = 5, alpha = NULL, check.alpha = TRUE,
  fix.alpha = FALSE, probs = 0, arrange = FALSE, fix.limits = TRUE,
  limit.exp = 1.05, lambda.scale = TRUE, procrustes.rotation = x$fixed ==
  "none", fix.lambda = FALSE, labs.grey = TRUE, label.0 = FALSE,
  tick.length = 0.0075 * diff(lims), axis.col = "grey60", label.size = 3,
  axis.size = 0.25, axis.title.size = 4, draw.axis = NULL,
  points.col = list(rows = "red", columns = "blue2"),
  offset.tick.labels = 3.5, offset.axis.title = list(rows = 0.015 *
  max(nchar(rnms)), columns = 0.015 * max(nchar(cnms))),
  axis.arrow = grid::arrow(angle = 20, length = grid::unit(0.0175, "npc")),
  ...)
}
\arguments{
\item{x}{An object of class \code{int.lsbclust}.}

\item{which}{A vector indicating which item segments to plot.}

\item{plot.type}{Character string giving the type of plots to produce: either \code{"biplots"}
for the biplots approximating the cluster means, \code{"means"} for level plots of the cluster means
themselves or \code{"estimates"} for level plots of the low-rank approximations of the cluster means
(as represented in the biplots).}

\item{segments}{A logical vector with two elements,  indicating whether the rows and columns should
be plotted as line segments or not.}

\item{biplot.axes}{A logical indicating whether to plot calibrated biplot axes for the line
segments indicated in \code{segments} or not.}

\item{nmarkers}{Either a single integer giving the number of desired markers per biplot axis
for all axes, or a named list. This is passed as the argument \code{n} to \code{\link{pretty}}. See
\code{Details} for information on the list option.}

\item{alpha}{Numeric value in [0, 1] which determines how the singular values are distributed
between rows and columns. It will trigger a recomputation of the updates if it does not correspond
to the value used when fitting the model.}

\item{check.alpha}{Logical indicating whether to look for a better alpha. This is only used when
\code{alpha = NULL} is used.}

\item{fix.alpha}{Logical indicating whether to fix alpha across all clusters or not
when \code{fixed == "none"}.}

\item{probs}{Argument passed to \code{\link{quantile}} to determine the alpha value. The
corresponding quantile of the distances of all points in the biplots to the origin will be
used to determine alpha in case check.alpha = TRUE.}

\item{arrange}{Logical indicating whether to arrange the plots side-by-side
via \code{\link{grid.arrange}} or not.}

\item{fix.limits}{Logical indicating whether biplot x- and y-limits must be fixed across clusters
or not. Note that this is automatically set to \code{TRUE} when \code{fixed == "rows"} or
\code{fixed == "columns"}. When limits are fixed, the axis calibrations are also turned off.}

\item{limit.exp}{A numeric expansion factor applied multiplicatively to the plot limits, but only
when \code{fixed} equals \code{"rows"} or \code{"columns"}.}

\item{lambda.scale}{Logical indicating whether to apply lambda scaling to the coordinates or not.
If true, the scaling is done such that the average squared distance to the origin is equal
for the row and column coordinates.}

\item{procrustes.rotation}{Logical indicating whether to do Procrustes rotations so that the
location of the axes indicated as segments (see argument \code{segments}) are similar
across configurations.}

\item{fix.lambda}{Logical indicating whether to fix lambda across all clusters or not.}

\item{labs.grey}{Logical indicating whether to apply greying to the text labels are well.}

\item{label.0}{Logical indicating whether to label the origin or not.}

\item{tick.length}{The required tick length as a \code{\link{unit}} object. It defaults to a
propoprtion of the width of the plot region (through lazy evaluation).}

\item{axis.col}{The colour of the biplot axes.}

\item{label.size}{The size of the labels for the markers on the biplot axes.}

\item{axis.size}{Line size for biplot axes.}

\item{axis.title.size}{Size of biplot axis titles.}

\item{draw.axis}{A list with up to two components which must be named \code{"rows"} and
\code{"columns"}. Each element contains a vector indicating which biplot axes should be drawn.
The vectors can be character vectors containing the names of the axes to be drawn, numeric
vectors containing indices indicating which axes to draw, or logical vectors indicating which
biplot axes to draw. In case of the default value \code{NULL}, the elements of \code{segments}
are used for the \code{"rows"} and \code{"columns"} entries.}

\item{points.col}{A named list containing the colours to use for plotting the sets of points. The
elements \code{"rows"} and \code{"columns"} contain vectors giving the colours for the points. Single
element vectors are recycled across the different points, otherwise the vectors must be of the
appropriate length.}

\item{offset.tick.labels}{A numeric value giving the offset factor of the biplot axis marker labels
from their respective tick marks. Higher (lower) values lead to labels being further from
(nearer to) their respective tick marks.}

\item{offset.axis.title}{A names list of (up to) two numeric values giving the fixed length offset of the
biplot axis title label from the end of the axis segment. The two elements must have names
\code{"rows"} and code{"columns"}.}

\item{axis.arrow}{An \code{\link{arrow}} object to be used for the endpoints of biplot axis
segment lines. This is passed to \code{\link{geom_segment}}.}

\item{\dots}{Additional arguments passed to \code{\link{theme}}.}
}
\description{
Two-dimensional plot method for object of class 'int.lsbclust' as output by \code{\link{int.lsbclust}}.
}
\details{
In case \code{nmarkers} is a list, it can have up to two elements. These are required to be named
\code{"rows"} and/or \code{"columns"}, otherwise an error will be thrown. The elements of the list
contains either single numeric values each or numeric vectors of the appropriate lengths
indicating the \code{n} argument passed to \code{\link{pretty}}.
}
\keyword{hplot}

