% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_cellarea.R
\name{calc_cellarea}
\alias{calc_cellarea}
\title{Calculate the cell area of LPJmL cells}
\usage{
calc_cellarea(
  x,
  cellsize_lon = 0.5,
  cellsize_lat = cellsize_lon,
  earth_radius = 6371000.785,
  return_unit = "m2"
)
}
\arguments{
\item{x}{\code{LPJmLData} object with \verb{$grid} attribute, an LPJmLData object of
variable \code{"grid"} (\code{"LPJGRID"}) or a vector of cell-center latitude
coordinates in degrees.}

\item{cellsize_lon}{Grid resolution in longitude direction in degrees
(default: \code{0.5}). If \code{x} is an LPJmLData object the resolution will be
taken from the meta data included in \code{x} if available.}

\item{cellsize_lat}{Grid resolution in latitude direction in degrees (default:
same as \code{cellsize_lon}). If \code{x} is an LPJmLData object the resolution will be
taken from the meta data included in \code{x} if available.}

\item{earth_radius}{Radius of the sphere (in \eqn{m}) used to calculate the
cell areas.}

\item{return_unit}{Character string describing the area unit of the returned
cell areas. Defaults to \code{"m2"}, further options: \code{"ha"} or \code{"km2"}.}
}
\value{
A vector or array matching the space dimension(s) of \code{x} if \code{x} is an
LPJmLData object. A vector of the same length as \code{x} if \code{x} is a vector of
latitude coordinates. Cell areas are returned in the unit \code{return_unit}.
}
\description{
Calculate the cell area of LPJmL cells based on an \code{\link{LPJmLData}}
object or latitude coordinates and grid resolution.
Uses a spherical representation of the Earth.
}
\examples{
grid <- matrix(
  data = c(-179.75, 89.75, -0.25, 0.25, 0.25, -0.25, 179.75, -89.75),
  ncol = 2,
  byrow = TRUE,
  dimnames = list(NULL, c("lon", "lat"))
)
gridarea <- calc_cellarea(grid[,"lat"])

}
