% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{ag_data}
\alias{ag_data}
\title{Data to estimate fiscal multipliers}
\format{A tibble (data.frame) with 248 quarterly observations (rows) and 7 variables (columns):
\describe{
  \item{Year}{Year of observation.}
  \item{Quarter}{Quarter of observation.}
  \item{Gov}{Logs of real government (federal, state, and local) purchases (consumption and investment).}
  \item{Tax}{Logs of real government receipts of direct and indirect taxes net of transfers to businesses
 and individuals.}
  \item{GDP}{Logs of real gross domestic product.}
  \item{GDP_MA}{7-quarter moving average growth rate of GDP.}
  \item{Gov_shock_mean}{Identified government spending shock. For details see Supplementary Appendix of Ramey and Zubairy (2018).}
}
Sample: 1948:IV - 2008:IV}
\source{
\url{https://www.journals.uchicago.edu/doi/10.1086/696277}
}
\usage{
ag_data
}
\description{
A \link{tibble} containing data to estimate fiscal multipliers.
             This data was originally used by Auerbach and Gorodnichenko (2012).
             Sarah and Zubairy (2018) use this data to re-evaluate their results with local projections
             by Jordà (2005).
}
\references{
Auerbach, A. J., and  Gorodnichenko Y. (2012). "Measuring the Output Responses to Fiscal Policy."
\emph{American Economic Journal: Economic Policy}, 4 (2): 1-27.

Jordà, Ò. (2005) "Estimation and Inference of Impulse Responses by Local Projections."
\emph{American Economic Review}, 95 (1): 161-182.

Ramey, V.A., Zubairy, S. (2018). "Government Spending Multipliers in Good Times
and in Bad: Evidence from US Historical Data." \emph{Journal of Political Economy},
126(2): 850 - 901.
}
\keyword{datasets}
