% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lphom.R
\name{lphom}
\alias{lphom}
\title{Implements lphom algorithm}
\usage{
lphom(
  votes_election1,
  votes_election2,
  new_and_exit_voters = c("regular", "raw", "simultaneous", "full", "gold"),
  structural_zeros = NULL,
  counts = FALSE,
  verbose = FALSE,
  solver = "lp_solve"
)
}
\arguments{
\item{votes_election1}{data.frame (or matrix) of order IxJ (likely of final order IxJ-1
in \code{regular} and \code{raw} scenarios) with the votes gained by the \emph{J}
political options competing on election 1 (or origin) in the \emph{I}
territorial units considered.}

\item{votes_election2}{data.frame (or matrix) of order IxK (likely of final order IxK-1
in \code{regular} and \code{raw} scenarios) with the votes gained by
the \emph{K} political options competing on election 2 (or destination)
in the \emph{I} territorial units considered.}

\item{new_and_exit_voters}{A character string indicating the level of information available
regarding new entries and exits of the election censuses between the
two elections. This argument captures the different options discussed
on Section 3 of Romero et al. (2020). This argument admits five values:
\code{regular}, \code{raw}, \code{simultaneous}, \code{full} and \code{gold}. Default, \code{regular}.}

\item{structural_zeros}{Default NULL. A list of vectors of length two, indicating the election options
for which no transfer of votes are allowed between election 1 and election 2.
For instance, when new_and_exit_voters is set to \code{"regular"},
lphom implicitly \verb{states structural_zeros = list(c(J, K))} in case exits and/or
entries are computed because the sum by rows of \code{votes_election1} and
\code{votes_election2} does not coincide.}

\item{counts}{A TRUE/FALSE value that indicates whether the linked LP solution of votes must be approximate
to the closest integer solution using ILP. Default, FALSE.}

\item{verbose}{A TRUE/FALSE value that indicates if the main outputs of the function should be
printed on the screen. Default, FALSE.}

\item{solver}{A character string indicating the linear programming solver to be used, only
\code{lp_solve} and \code{symphony} are allowed. By default, \code{lp_solve}.}
}
\value{
A list with the following components
\item{VTM}{ A matrix of order JxK with the estimated percentages of row-standardized vote transitions from election 1 to election 2.}
\item{VTM.votes}{ A matrix of order JxK with the estimated vote transitions from election 1 to election 2.}
\item{OTM}{ A matrix of order KxJ with the estimated percentages of the origin of the votes obtained for the different options of election 2.}
\item{HETe}{ The estimated heterogeneity index defined in equation (11) of Romero et al. (2020).}
\item{VTM.complete}{ A matrix of order J'xK' with the estimated proportions of row-standardized vote transitions from election 1 to election 2, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
\item{VTM.complete.votes}{ A matrix of order J'xK' with the estimated vote transitions from election 1 to election 2, including in \code{regular} and \code{raw} scenarios the row and the column corresponding to net_entries and net_exits even when they are really small, less than 1\% in all units.}
\item{inputs}{ A list containing all the objects with the values used as arguments by the function.}
\item{origin}{ A matrix with the final data used as votes of the origin election after taking into account the level of information available regarding to new entries and exits of the election censuses between the two elections.}
\item{destination}{ A matrix with the final data used as votes of the origin election after taking into account the level of information available regarding to new entries and exits of the election censuses between the two elections.}
\item{EHet}{ A matrix of order IxK measuring in each spatial unit a distance to the homogeneity hypothesis. That is, the differences under the homogeneity hypothesis between the actual recorded results and the expected results in each territorial unit for each option of election two.}
}
\description{
Estimates RxC vote transfer matrices (ecological contingency tables) with lphom
}
\details{
Description of the \code{new_and_exit_voters} argument in more detail.
\itemize{
\item{\code{regular}: }{The default value. This argument accounts for the most plausible scenario.
A scenario with two elections elapsed at least some months.
In this scenario, (i) the column \emph{J} of  \code{votes_election1} corresponds to
new young electors who have the right to vote for the first time and (ii)
net exits (basically a consequence of mortality), and eventually net entries,
are computed according equation (7) of Romero et al. (2020), and (iii) we
assume net exits affect equally all the first \emph{J-1} options of election 1,
hence (8) and (9) constraints of Romero et al. (2020) are imposed.}
\item{\code{raw}: }{This value accounts for a scenario with two elections where only the raw
election data recorded in the \emph{I} territorial units, in which the area
under study is divided, are available. In this scenario, net exits
(basically deaths) and net entries (basically new young voters) are estimated
according to equation (7) of Romero et al. (2020). Constraints defined by
equations (8) and (9) of Romero et al. (2020) are imposed. In this scenario,
when net exits and/or net entries are negligible (such as between the first- and
second-round of French Presidential elections), they are omitted in the outputs.}
\item{\code{simultaneous}: }{This value accounts for either a scenario with two simultaneous elections
or a classical ecological inference problem. In this scenario, the sum by rows
of \code{votes_election1} and \code{votes_election2} must coincide. Constraints
defined by equations (8) and (9) of Romero et al. (2020) are not included
in the model.}
\item{\code{full}: }{This value accounts for a scenario with two elections elapsed at least some
months, where: (i) the column \emph{J-1} of votes_election1 totals new young
electors that have the right to vote for the first time; (ii) the column \emph{J}
of votes_election1 measures new immigrants that have the right to vote; and
(iii) the column \emph{K} of votes_election2 corresponds to total exits of the census
lists (due to death or emigration). In this scenario, the sum by rows of
\code{votes_election1} and \code{votes_election2} must agree and constraints (8)
and (9) of Romero et al. (2020) are imposed.}
\item{\code{gold}: }{This value accounts for a scenario similar to full, where total exits are
separated out between exits due to emigration (column \emph{K-1} of \code{votes_election2})
and death (column \emph{K} of \code{votes_election2}). In this scenario, the sum by rows
of \code{votes_election1} and \code{votes_election2} must agree. The same restrictions
as in the above scenario apply but for both columns \emph{K-1} and \emph{K} of the vote
transition probability matrix}
}
}
\examples{
lphom(France2017P[, 1:8] , France2017P[, 9:12], new_and_exit_voters= "raw")
}
\references{
Romero, R, Pavia, JM, Martin, J and Romero G (2020). Assessing uncertainty of voter transitions estimated from aggregated data. Application to the 2017 French presidential election. \emph{Journal of Applied Statistics}, 47(13-15), 2711-2736. \doi{10.1080/02664763.2020.1804842}
}
\seealso{
\code{\link{tslphom}} \code{\link{nslphom}} \code{\link{lclphom}}

Other linear programing ecological inference functions: 
\code{\link{lclphom}()},
\code{\link{lphom_dual}()},
\code{\link{lphom_joint}()},
\code{\link{nslphom_dual}()},
\code{\link{nslphom_joint}()},
\code{\link{nslphom}()},
\code{\link{tslphom_dual}()},
\code{\link{tslphom_joint}()},
\code{\link{tslphom}()}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
\concept{linear programing ecological inference functions}
