% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity_methods.R
\name{coef.lpdensity}
\alias{coef.lpdensity}
\title{Coef Method for Local Polynomial Density Estimation and Inference}
\usage{
\method{coef}{lpdensity}(object, ...)
}
\arguments{
\item{object}{Class "lpdensity" object, obtained by calling \code{\link{lpdensity}}.}

\item{...}{Additional options.}
}
\value{
A matrix containing grid points and density estimates using p- and q-th order local polynomials.
}
\description{
The coef method for local polynomial density objects.
}
\examples{
# Generate a random sample
set.seed(42); X <- rnorm(2000)

# Estimate density and report results
coef(lpdensity(data = X, bwselect = "imse-dpi"))

}
\seealso{
\code{\link{lpdensity}} for local polynomial density estimation.

Supported methods: \code{\link{coef.lpdensity}}, \code{\link{confint.lpdensity}},
  \code{\link{plot.lpdensity}}, \code{\link{print.lpdensity}}, \code{\link{summary.lpdensity}},
  \code{\link{vcov.lpdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
