% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplements.R
\name{log_code}
\alias{log_code}
\title{Log the current program code}
\usage{
log_code()
}
\value{
A TRUE or FALSE value to indicate success or failure of the
function.
}
\description{
A function to send the program/script code to the
currently opened log.  The log must be opened first with
\code{\link{log_open}}.  Code will be prefixed with a right arrow (">")
to differentiate it from standard logging lines.  The \code{log_code}
function may be called from anywhere within the program.  Code will
be inserted into the log at the point where it is called.  The
\code{log_code} function will log the code as it is saved on disk.  It
will not capture any unsaved changes in the editor.  If the current
program file cannot be found, the function will return FALSE and no
code will be written.
}
\examples{
# Create temp file location
tmp <- file.path(tempdir(), "test.log")

# Open log
lf <- log_open(tmp)

# Write code to the log
log_code()

# Send message to log
log_print("High Mileage Cars Subset")

# Perform operations
hmc <- subset(mtcars, mtcars$mpg > 20)

# Print data to log
log_print(hmc)

# Close log
log_close()

# View results
writeLines(readLines(lf))
}
\seealso{
\code{\link{log_open}} to open the log,
and \code{\link{log_close}} to close the log.
}
