% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_scatter.R
\name{gg_scatter}
\alias{gg_scatter}
\title{Locus scatter plot using ggplot2}
\usage{
gg_scatter(
  loc,
  index_snp = loc$index_snp,
  pcutoff = 5e-08,
  scheme = c("royalblue", "red", "purple"),
  size = 2,
  cex.axis = 1,
  cex.lab = 1,
  xlab = NULL,
  ylab = NULL,
  yzero = (loc$yvar == "logP"),
  xticks = TRUE,
  border = FALSE,
  showLD = TRUE,
  LD_scheme = c("grey", "royalblue", "cyan2", "green3", "orange", "red", "purple"),
  recomb_col = "blue",
  legend_pos = "topleft"
)
}
\arguments{
\item{loc}{Object of class 'locus' to use for plot. See \link{locus}.}

\item{index_snp}{Specifies index SNP to be shown in a different colour and
symbol. Defaults to the SNP with the lowest p-value. Set to \code{NULL} to not
show this.}

\item{pcutoff}{Cut-off for p value significance. Defaults to p = 5e-08. Set
to \code{NULL} to disable.}

\item{scheme}{Vector of 3 colours if LD is not shown: 1st = normal points,
2nd = colour for significant points, 3rd = index SNP.}

\item{size}{Specifies size for points.}

\item{cex.axis}{Specifies font size for axis numbering.}

\item{cex.lab}{Specifies font size for axis titles.}

\item{xlab}{x axis title.}

\item{ylab}{y axis title.}

\item{yzero}{Logical whether to force y axis limit to include y=0.}

\item{xticks}{Logical whether x axis numbers and axis title are plotted.}

\item{border}{Logical whether a bounding box is plotted around the plot.}

\item{showLD}{Logical whether to show LD with colours}

\item{LD_scheme}{Vector of colours for plotting LD. The first colour is for SNPs
which lack LD information. The next 5 colours are for r2 or D' LD results
ranging from 0 to 1 in intervals of 0.2. The final colour is for the index
SNP.}

\item{recomb_col}{Colour for recombination rate line if recombination rate
data is present. Set to NA to hide the line. See \code{\link[=link_recomb]{link_recomb()}} to add
recombination rate data.}

\item{legend_pos}{Position of legend. Set to \code{NULL} to hide legend.}
}
\value{
Returns a ggplot2 plot.
}
\description{
Produces a scatter plot from a 'locus' class object (without gene tracks).
}
\details{
If recombination rate data is included in the locus object following a call
to \code{\link[=link_recomb]{link_recomb()}}, this is plotted as an additional line with a secondary y
axis. In the base graphics version the line is placed under the scatter
points, but this is not possible with ggplot2 as the secondary y axis data
must be plotted on top of the primary scatter point data.
}
\examples{
if(require(EnsDb.Hsapiens.v75)) {
data(SLE_gwas_sub)
loc <- locus(SLE_gwas_sub, gene = 'IRF5', flank = c(7e4, 2e5), LD = "r2",
             ens_db = "EnsDb.Hsapiens.v75")
gg_scatter(loc)
}
}
\seealso{
\code{\link[=locus]{locus()}} \code{\link[=gg_addgenes]{gg_addgenes()}}
}
