% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadr.R
\name{eload}
\alias{eload}
\title{Loads named variables into a shared environment}
\usage{
eload(loadDat, loadEnvir = loadrEnv(), preserve = FALSE,
  parentEnvir = globalenv())
}
\arguments{
\item{loadDat}{A \code{list} or \code{environment} with named variables to load.}

\item{loadEnvir}{Name (character string) for the environment to create or
update.}

\item{preserve}{Whether to retain the value for an already-bound name.}

\item{parentEnvir}{Parent environment of the shared variable environment;
defaults to \code{globalenv()}}
}
\description{
\code{eload} takes a collection of named objects and creates or updates an
environment. By default, an existing variable in the target environment will
be replaced by a new value, but this can be avoided by setting
\code{preserve=TRUE}. If you want to load directly into the current env, look
at \code{list2env} with
\code{environment()}
}
\examples{
eload(list(x=15))
SV$x
}
