% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_plot.R
\name{event_plot}
\alias{event_plot}
\title{Visualize hydrological events interactively}
\usage{
event_plot(
  dataframe,
  q,
  datetime,
  he,
  ssc,
  ylabel = "Water discharge",
  y2label = "Suspended Sediment Concentration"
)
}
\arguments{
\item{dataframe}{A data set object}

\item{q}{Water discharge variable (or water stage)}

\item{datetime}{Datetime variable (column in POSIXct format)}

\item{he}{Hydrological event variable (or other day column)}

\item{ssc}{Suspended sediment concentration variable (to plot on a
second axis)}

\item{ylabel}{Y-axis label}

\item{y2label}{Second Y-axis label}
}
\value{
The `event_plot` function returns object of class "dygraphs",
"htmlwidget"
}
\description{
This function creates an interactive plot using \code{dygraphs}
package
}
\examples{
library(dplyr)
data(djan)
djan \%>\%
  hydro_events(
    q = discharge,
    datetime = time,
    window = 21
  ) \%>\%
  event_plot(q = SS, datetime = time, he = he)
}
