% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information-matrices.R
\name{extract_varcomp}
\alias{extract_varcomp}
\title{Extract estimated variance components}
\usage{
extract_varcomp(mod)
}
\arguments{
\item{mod}{Fitted model of class lmeStruct or glsStruct.}
}
\value{
Object of class \code{varcomp} consisting of a list of estimated
  variance components. Models that do not include correlation structure
  parameters or variance structure parameters will have empty lists for those
  components.
}
\description{
Extracts the estimated variance components
  from a fitted linear mixed effects model (lmeStruct object)
  or generalized least squares model (glsStruct object).
}
\examples{

library(nlme)
data(Bryant2016)
Bryant2016_RML <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      data = Bryant2016)
extract_varcomp(Bryant2016_RML)

}
