% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/litterFitter-package.R
\docType{package}
\name{litterfitter}
\alias{litterfitter}
\alias{litterfitter-package}
\title{litterfitter: methods for fitting curves to litter decomposition trajectories}
\description{
There is a long tradition of studying the flux of carbon from 
the biosphere to the atmosphere by following a particular cohort of litter
(wood, leaves, roots, or other organic material) through time.  The 
resulting data are mass remaining and time.  A variety of functional forms
may be used to fit the resulting data.  Some work better empirically.  
Some are better connected to a process-based understanding.  
Some have a small number of free parameters; others have more. 
This package matches decomposition data to a set of these curves 
using likelihood--based fitting.
}
\references{
Cornwell, W. K., and J. T. Weedon. (2013). Decomposition trajectories of diverse litter types: a model selection analysis. Methods in Ecology and Evolution.

Manzoni, S., Pineiro, G., Jackson, R. B., Jobbagy, E. G., Kim, J. H., & Porporato, A. (2012). Analytical models of soil and litter decomposition: Solutions for mass loss and time-dependent decay rates. Soil Biology and Biochemistry, 50, 66-76.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/traitecoevo/litterfitter/issues}
  \item \url{http://traitecoevo.github.io/litterfitter/}
  \item Report bugs at \url{https://github.com/traitecoevo/litterfitter/issues}
}

}
\author{
\strong{Maintainer}: Will Cornwell \email{wcornwell@gmail.com} (\href{https://orcid.org/0000-0003-4080-4073}{ORCID})

Authors:
\itemize{
  \item James Weedon
}

Other contributors:
\itemize{
  \item Guofang Liu [contributor]
}

}
