% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-utils.R
\name{list_str}
\alias{list_str}
\title{Summarise the structure of a list}
\usage{
list_str(l, name_variables = "names",
  stringsAsFactors = getOption("stringsAsFactors"))
}
\arguments{
\item{l}{A variable, probably a list.}

\item{name_variables}{A string. What should the columns formed from
the names of \code{l} be called?}

\item{stringsAsFactors}{Should character columns be converted to factors?}
}
\value{
\code{\link[base]{data.frame}}.
}
\description{
Summarise the structure of a list, in a tidy data frame.
}
\examples{
l <- list(
  a = 1,
  b = matrix(1:6, 2),
  c = list(
    ca = y ~ x,
    list(cba = median, cbb = quote(1 + 1), cbc = expression(1 + 1)),
    cc = list(cca = as.name("xyz"))
  ),
  d = array(1:24, 2:4)
)
list_str(l)
}
\seealso{
\code{\link[utils]{str}}, \code{\link{list_to_data.frame}}
}

