% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-site.r
\name{ld_build_html_site}
\alias{ld_build_html_site}
\title{Build an html Site from listdown Document Bundles}
\usage{
ld_build_html_site(
  doc_bundles,
  site_yaml,
  site_dir = tempdir(),
  rmd_dir = file.path(site_dir, "rmarkdown"),
  data_dir = file.path(site_dir, "data"),
  html_dir = file.path(site_dir, "html"),
  render_site = TRUE,
  view = interactive(),
  make_data_dir = TRUE,
  make_rmd_dir = TRUE,
  ...
)
}
\arguments{
\item{doc_bundles}{a named list of document bundles. There can be up to one
unnamed bundle, which will be assumed to correspond to an index.rmd file.}

\item{site_yaml}{a list of site information, which will be written
to the _site.yml file.}

\item{site_dir}{the directory where the site (rmd, data, and html files)
will be written to.}

\item{rmd_dir}{the directory where the R Markdown files will reside. By 
default an "rmarkdown" file is written to `tempdir()`.}

\item{data_dir}{the location where data can be found for each bundle.
If the data is held in memory for a listdown document bundle, then it will
be written to the specified directory. If multiple directories are specified,
then the directory is specified per bundle, with index recycling used if
the number of directories is not the same as the number of bundles.}

\item{html_dir}{the location of the rendered document, relative to the 
directory specified by `rmd_dir`. Note that this is an {{rmarkdown}}
convention. By default a directory names "html" is created in the 
directory specified by `rmd_dir` and rendered documents are place there.}

\item{render_site}{should the page be rendered? If not then the 
`html_dir` is not created.}

\item{view}{should the output document be opened after rendering? By 
default, if `render_doc` is `TRUE` and this argument is `TRUE` then
the browser will open for you to examine the output.}

\item{make_data_dir}{if the `data_dir` directory is not present, should it
be created? This can be set to `FALSE` when data already resides on disk
to verify that it is not being created and written.}

\item{make_rmd_dir}{if the `rmd_dir` directory is not present, should it
be created? This can be set to `FALSE` when data already resides on disk
to verify that it is not being created and written.}

\item{...}{argument to be passed to the `rmarkdown::render_site()` function.}
}
\value{
The path to the created website.
}
\description{
This function creates an html website with each tab in the
page being described by a listdown document bundle.
}
\seealso{
ld_bundle_doc ld_create_doc
}
