## ----echo=FALSE, message=FALSE, warning=FALSE, results='hide'---------------------------------------------------------
knitr::opts_chunk$set(fig.align="center", fig.width=6, fig.height=4, warning=FALSE, message=FALSE)
options(width=120)
library(linpk, quietly=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
t.obs <- seq(0, 24, 0.1)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, dose=list(amt=100))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
sim <- as.data.frame(y)
tail(sim)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, dose=list(amt=100, dur=1.5))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(amt=100))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(amt=100, lag=0.4, f=0.6))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(t.dose=c(0, 12), amt=100))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(t.dose=c(0, 12), amt=c(100, 50)))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
doses <- data.frame(t.dose=c(0, 12), amt=c(100, 50))
doses
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=doses)
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
t.obs <- seq(0, 6*24, 0.5)
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(amt=100, addl=9, ii=12))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(t.dose=seq(0, 9*12, 12), amt=100))
plot(y, col="red")

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3,
    dose=list(t.dose=c(0, 24*2 + 14), amt=c(100, 50), addl=c(4, 0), ii=24))
plot(y)

## ---------------------------------------------------------------------------------------------------------------------
dose.frame(y)

## ---------------------------------------------------------------------------------------------------------------------
t.obs <- seq(0, 6*24, 0.5)
y <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(amt=100, addl=9, ii=12))
plot(y)
yss <- pkprofile(t.obs, cl=0.5, vc=11, ka=1.3, dose=list(amt=100, addl=9, ii=12, ss=T))
lines(yss, col="green3")
legend("bottomright", c("Steady state"), col=c("green3"), lty=1, bty="n")

## ---------------------------------------------------------------------------------------------------------------------
t.obs <- seq(0, 24, 0.1)
y2 <- pkprofile(t.obs, cl=0.5, vc=11, q=2, vp=30, ka=1.3, dose=list(amt=100))

## ---------------------------------------------------------------------------------------------------------------------
y3 <- pkprofile(t.obs, cl=0.5, vc=11, q=c(2, 0.3), vp=c(30, 3), ka=1.3, dose=list(amt=100))
plot(y2)
lines(y3, col="green3")
legend("topright", c("2-Compartment", "3-Compartment"), col=c("black", "green3"), lty=1, bty="n")

## ---------------------------------------------------------------------------------------------------------------------
y <- pkprofile(t.obs, cl=0.5, vc=11, q=c(2, 0.3), vp=c(30, 3), ka=1.3, dose=list(amt=100))
halflife(y)

## ---------------------------------------------------------------------------------------------------------------------
halflife(pkprofile(cl=0.5, vc=11, q=2, vp=30))

## ---------------------------------------------------------------------------------------------------------------------
secondary(y)

## ---------------------------------------------------------------------------------------------------------------------
t.obs <- seq(0, 5*24, 0.1)
y <- pkprofile(t.obs, cl=0.5, vc=11, q=2, vp=30, ka=1.3, dose=list(amt=100, addl=5, ii=24))
plot(y)
secondary(y)

## ---------------------------------------------------------------------------------------------------------------------
secondary(y, From=c(0, 0, 48), To=c(12, 48, 128))

## ---------------------------------------------------------------------------------------------------------------------
t.obs <- seq(0, 20, 0.1)
doses <- data.frame(t.dose=c(0, 7), amt=c(150, 10), addl=c(0, 12), ii=1, cmt=c(1, 0), dur=c(1/24, 0))
doses
y <- pkprofile(t.obs, cl=0.8, vc=6, q=0.09, vp=4.5, ka=1.3, dose=doses)
plot(y, col="blue", main="150 mg IV at time zero, 10 mg SC QD on days 8 to 20", xlab="Time (days)")

## ---------------------------------------------------------------------------------------------------------------------
t.grid <- seq(0, 24, 0.1)
t.dose <- seq(0, by=24, len=8)
cl0 <- 0.1; cl <- cl0; ka <- 0.5; vc <- 10
y <- pkprofile(t.obs=t.grid, cl=cl, vc=vc, ka=ka, dose=list(t.dose=0))
for (day in 2:8) {
    cl <- 1.2*cl
    y <- pkprofile(y, t.obs=t.grid + t.dose[day], cl=cl, vc=vc, ka=ka, dose=list(t.dose=t.dose[day]))
}
plot(y, main="Clearance increasing by 20% each day")

## ----eval=F-----------------------------------------------------------------------------------------------------------
#  linpkApp()

