% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{runOTB}
\alias{runOTB}
\title{Execute the OTB command list via system call}
\usage{
runOTB(otbCmdList = NULL, gili = NULL, retRaster = TRUE, quiet = TRUE)
}
\arguments{
\item{otbCmdList}{the OTB algorithm parameter list}

\item{gili}{optional gis linkage as done by `linkOTB()`}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{quiet}{boolean  switch for supressing messages default is TRUE}
}
\description{
Wrapper function which paste the OTB command list into a system call compatible string and execute this command.
}
\examples{
\dontrun{
require(link2GI)
require(raster)
require(listviewer)

## link to OTB
otbLink<-link2GI::linkOTB()

if (otblink$exist) {
 projRootDir<-tempdir()
 data("rgb")
 raster::plotRGB(rgb)
 r<-raster::writeRaster(rgb, 
                        filename=file.path(projRootDir,"test.tif"),
                        format="GTiff", 
                        overwrite=TRUE)

## for the example we use the Statistic Extraction, 
algoKeyword<- "LocalStatisticExtraction"

## extract the command list for the choosen algorithm 
cmd<-parseOTBFunction(algo = algoKeyword, gili = otbLink)

## get help using the convenient listviewer
listviewer::jsonedit(cmd$help)

## define the mandantory arguments all other will be default
cmd$input  <- file.path(tempdir(),"test.tif")
cmd$out <- file.path(tempdir(),"test_otb_stat.tif")
cmd$radius <- 7

## run algorithm
retStack<-runOTB(cmd,gili = otbLink)

## plot raster
raster::plot(retStack)

}
}
}
