% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPsamplers.R
\name{tmvrnorm.Gibbs}
\alias{tmvrnorm.Gibbs}
\title{\code{"tmvrnorm"} Sampler for \code{"Gibbs"} (Gibbs Sampling) S3 Class}
\usage{
\method{tmvrnorm}{Gibbs}(object, nsim, control = list(thinning = 100,
  burn.in = 100), ...)
}
\arguments{
\item{object}{an object with \code{"Gibbs"} S3 class containing:
\code{mu} (mean vector), \code{Sigma} (covariance matrix),
\code{lb} (lower bound vector), \code{ub} (upper bound vector).}

\item{nsim}{an integer corresponding to the number of simulations.}

\item{control}{extra parameters required for the MC/MCMC sampler.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with the simulated samples. Samples are indexed by columns.
}
\description{
Sampler for truncated multivariate normal distributions
via Gibbs sampling using the package \code{restrictedMVN} (Taylor and Benjamini, 2017).
}
\examples{
n <- 100
x <- seq(0, 1, length = n)
Sigma <- kernCompute(x1 = x, type = "gaussian", par = c(1,0.2))
tmgPar <- list(mu = rep(0,n), Sigma = Sigma + 1e-9*diag(n), lb = rep(-1,n), ub = rep(1,n))
class(tmgPar) <- "Gibbs"
y <- tmvrnorm(tmgPar, nsim = 10)
matplot(x, y, type = 'l', ylim = c(-1,1),
        main = "Constrained samples using Gibbs sampling")
abline(h = c(-1,1), lty = 2)

}
\references{
Taylor, J. and Benjamini, Y. (2017),
"RestrictedMVN: multivariate normal restricted by affine constraints".
}
\seealso{
\code{\link{tmvrnorm.RSM}},
         \code{\link{tmvrnorm.HMC}}, \code{\link{tmvrnorm.ExpT}}
}
\author{
A. F. Lopez-Lopera.
}
