% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{get_valid_rows}
\alias{get_valid_rows}
\title{identify missing rows for model/formula.}
\usage{
get_valid_rows(model, data)
}
\arguments{
\item{model}{a formula or an output of lm or glm}

\item{data}{the data.frame supposed to be used in modelling}
}
\value{
a boolean vector with same length as the number of rows of data, with TRUE if a row has full data for the modelling and FALSE if not.
}
\description{
identify missing rows for model/formula.
}
\details{
Data often contains missing values and \code{lm()} or \code{glm()} often skip those rows.
This function is to identify which rows that \code{lm()} or \code{glm()} skips.
}
\examples{

model = lm(price ~ carat, head(ggplot2::diamonds,1000))
data = head(ggplot2::diamonds,10)

# so observation 1, 4, 7 will be not valid rows
data[c(1,4,7),"price"] = NA
data
get_valid_rows(model,data)

# error message as no "price" is found in the data
data[,"price"] = NULL
tryCatch(get_valid_rows(model,data),
         error = function(x){
           print(x)
         })

}

