% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DropPatterns.R
\name{DropPatterns}
\alias{DropPatterns}
\title{Drop species with given patterns in name}
\usage{
DropPatterns(
  data,
  patterns = c("sp.", "/", "Domestic type", "hybrid"),
  colname = "comName"
)
}
\arguments{
\item{data}{A data.frame with observations, likely the object from a call to
\code{RecentNearby}.}

\item{patterns}{Character vector of patterns in \code{colname} column to
omit.}

\item{colname}{Character vector indicating column with names to search for
\code{patterns}.}
}
\value{
Copy of \code{data} with any rows that has values in \code{colname}
that match values in \code{patterns}.
}
\description{
Drop species with given patterns in name
}
\details{
This utility function provides a means of omitting observations of
"other taxa" such as domestics, hybrids, and "sp." observations. If
\code{patterns = NULL}, no rows will be dropped.
}
\examples{
df <- data.frame(comName = c("Mallard", "Mallard x Mexican Duck hybrid", "Verdin"),
                 date = c("2021-01-09", "2021-01-09", "2021-01-09"))
df <- DropPatterns(data = df)

}
\keyword{internal}
