% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{convert_raster}
\alias{convert_raster}
\title{Raster format conversion}
\usage{
convert_raster(r, pkg = NULL)
}
\arguments{
\item{r}{raster object or file name.}

\item{pkg}{package name. Use pkg = "terra|
raster|stars" to get an output in SpatRaster, RasterLayer or stars format}
}
\value{
A raster object in the specified format
}
\description{
Function to convert between raster formats. Use pkg = "terra|raster|stars" to get an output in SpatRaster, RasterLayer
or stars format. Default is getOption("lidR.raster.default").
}
\examples{
# load SpatRaster
data(chm_chablais3)
chm_chablais3 <- terra::rast(chm_chablais3)
# convert only if packages stars and raster are installed
# if (require("stars"))
# {
# to stars
# chm_stars <- convert_raster(chm_chablais3, pkg = "stars")
# chm_stars
# }
if (require("raster"))
{
# to raster
chm_raster <- convert_raster(chm_chablais3, pkg = "raster")
chm_raster
# back to terra
convert_raster(chm_raster, pkg = "terra")
}
}
