% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregistration.R
\name{rasterLocalmax}
\alias{rasterLocalmax}
\title{Statistics of raster local maximum}
\usage{
rasterLocalmax(r, dm = 2, med1 = 1, med2 = 2, quanta = 0.75, quantb = 0.5)
}
\arguments{
\item{r}{raster. typically output of \code{\link{rastersMovingCor}}}

\item{dm}{numeric. minimum distance between two local maxima in meters}

\item{med1}{numeric. window radius to compute median value around the maximum position (default: 1m)}

\item{med2}{numeric. window radius #2 to compute median value around the maximum position (default: 2m)}

\item{quanta}{numeric. quantile value to compute for raster values (default: 3rd quartile)}

\item{quantb}{numeric. quantile #2 value to compute for raster values (default: median)}
}
\value{
A data.frame with value of maximum, position of maximum, position of second maximum, ratio of max value to 2nd max, ratio of max value to median of neighborhood (size1 and size 2), ratio of max value to raster quantiles 1 and 2
}
\description{
identifies global maximum and second global maximum from raster (e.g. output from \code{\link{rastersMovingCor}}), and computes related statistics. Local maxima can be excluded based on a minimum distance \code{dm} to nearest local maximum.
}
\examples{
# create raster
r.b <- raster::raster()
raster::extent(r.b) <- c(0,40,0,40)
raster::res(r.b) <- 1
xy <- raster::xyFromCell(r.b,1:length(r.b))

# add Gaussian surfaces
z1 <- 1.5*exp(-((xy[,1]-22)^2+(xy[,2]-22)^2/2)/5)
z2 <- exp(-((xy[,1]-20)^2+(xy[,2]-22)^2/2)/3)
z3 <- 1.5*exp(-((xy[,1]-17)^2+(xy[,2]-17)^2/2)/5)
r.b <- raster::rasterFromXYZ(cbind(xy,z1+z2+z3))

# create small raster
r.s <- raster::crop(r.b, raster::extent(c(15,25,15,25)))
# offset raster by (-2, -2)
raster::extent(r.s) <- c(13,23,13,23)

rr <- rastersMovingCor(r.b, r.s, buffer=6, step=1)
loc.max <- rasterLocalmax(rr)
loc.max

# plot raster
raster::plot(rr)
# add location of two local maxima
graphics::points(loc.max[1,c("dx1","dx2")], loc.max[1,c("dy1","dy2")],
                 cex=c(1,0.5), pch=3)
}
\seealso{
\code{\link{rastersMovingCor}}, \code{\link{coregistration}} for application to the coregistration of tree inventory data with canopy height models
}
