% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-gnd.R
\name{gnd_pmf}
\alias{gnd_pmf}
\alias{pmf}
\alias{util_makeZhangParam}
\title{Ground Segmentation Algorithm}
\usage{
pmf(ws, th)

util_makeZhangParam(
  b = 2,
  dh0 = 0.5,
  dhmax = 3,
  s = 1,
  max_ws = 20,
  exp = FALSE
)
}
\arguments{
\item{ws}{numeric. Sequence of windows sizes to be used in filtering ground returns.
The values must be positive and in the same units as the point cloud (usually meters, occasionally
feet).}

\item{th}{numeric. Sequence of threshold heights above the parameterized ground surface to be
considered a ground return. The values must be positive and in the same units as the point cloud.}

\item{b}{numeric. This is the parameter \eqn{b} in Zhang et al. (2003) (eq. 4 and 5).}

\item{dh0}{numeric. This is \eqn{dh_0} in Zhang et al. (2003) (eq. 7).}

\item{dhmax}{numeric. This is \eqn{dh_{max}} in Zhang et al. (2003) (eq. 7).}

\item{s}{numeric. This is \eqn{s} in Zhang et al. (2003) (eq. 7).}

\item{max_ws}{numeric. Maximum window size to be used in filtering ground returns. This limits
the number of windows created.}

\item{exp}{logical. The window size can be increased linearly or exponentially (eq. 4 or 5).}
}
\description{
This function is made to be used in \link{classify_ground}. It implements an algorithm for segmentation
of ground points based on a progressive morphological filter. This method is an implementation of
the Zhang et al. (2003) algorithm (see reference). Note that this is not a strict implementation
of Zhang et al. This algorithm works at the point cloud level without any rasterization process.
The morphological operator is applied on the point cloud, not on a raster. Also, Zhang et al.
proposed some formulas (eq. 4, 5 and 7) to compute the sequence of windows sizes and thresholds.
Here, these parameters are free and specified by the user. The function \link{util_makeZhangParam}
enables computation of the parameters according to the original paper.
}
\details{
The progressive morphological filter allows for any sequence of parameters. The `util_makeZhangParam`
function enables computation of the sequences using equations (4),
 (5) and (7) from Zhang et al. (see reference and details).


In the original paper the windows size sequence is given by eq. 4 or 5:\cr\cr
\eqn{w_k = 2kb + 1} \cr\cr
or\cr\cr
\eqn{w_k = 2b^k + 1}\cr\cr
In the original paper the threshold sequence is given by eq. 7:\cr\cr
\eqn{th_k = s*(w_k - w_{k-1})*c + th_0}\cr\cr
Because the function \link{classify_ground} applies the morphological operation at the point
cloud level the parameter \eqn{c} is set to 1 and cannot be modified.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile, select = "xyzrn", filter = "-inside 273450 5274350 273550 5274450")

ws <- seq(3,12, 3)
th <- seq(0.1, 1.5, length.out = length(ws))

las <- classify_ground(las, pmf(ws, th))
#plot(las, color = "Classification")
}
\references{
Zhang, K., Chen, S. C., Whitman, D., Shyu, M. L., Yan, J., & Zhang, C. (2003). A progressive
morphological filter for removing nonground measurements from airborne LIDAR data. IEEE
Transactions on Geoscience and Remote Sensing, 41(4 PART I), 872–882. http:#doi.org/10.1109/TGRS.2003.810682.
}
\seealso{
Other ground segmentation algorithms: 
\code{\link{gnd_csf}},
\code{\link{gnd_mcc}}
}
\concept{ground segmentation algorithms}
