% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LASmethods-generic.r, R/Class-LASheader.r,
%   R/LASmethods-LAS.r
\docType{methods}
\name{epsg}
\alias{epsg}
\alias{epsg<-}
\alias{epsg,LASheader-method}
\alias{epsg<-,LASheader-method}
\alias{epsg,LAS-method}
\alias{epsg<-,LAS-method}
\title{Get or set epsg code of a LAS* object}
\usage{
epsg(object, ...)

epsg(object) <- value

\S4method{epsg}{LASheader}(object, ...)

\S4method{epsg}{LASheader}(object) <- value

\S4method{epsg}{LAS}(object)

\S4method{epsg}{LAS}(object) <- value
}
\arguments{
\item{object}{An object of class LAS or eventually LASheader (regular users don't need to manipulate
LASheader objects)}

\item{...}{Unused}

\item{value}{integer. EPSG code.}
}
\description{
Currently, at least in R, the only way to store the CRS in a las file is to store the epsg code of
the CRS. On the other hand, all spatial R packages use the proj4string to store the CRS. This is why
the CRS is duplicated in a LAS object. The proj4string is accessible with the functions \code{projection}
from \code{raster} or \code{proj4string} from \code{sp}. These functions do nothing special except
they return or update the proj4string, which is not recognized in a las file. The function \code{epsg},
in turn, updates the header of the LAS object \strong{and} updates the proj4string and thus should
be preferred to ensure that the CRS will be written into a las file.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)

projection(las)
epsg(las)

# Changing the CRS via projection updates the proj4string but not the header
# The proj4string will be propagated in all subsequent spatial objects but the las file
# itself will still have the epsg code 26917 if written on the disk
projection(las) = sp::CRS("+init=epsg:2567")
projection(las)
epsg(las)

# Changing the CRS via epsg updates the proj4string and the header. This way the good CRS will
# written in the las file (if written).
epsg(las) = 2567
epsg(las)
projection(las)
}
