% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libproj-package.R
\name{libproj_version}
\alias{libproj_version}
\alias{libproj_has_libtiff}
\alias{libproj_has_libcurl}
\alias{libproj_temp_dir}
\alias{with_libproj_configuration}
\alias{libproj_configuration}
\alias{libproj_configure}
\title{PROJ configuration}
\usage{
libproj_version()

libproj_has_libtiff()

libproj_has_libcurl()

libproj_temp_dir()

with_libproj_configuration(config, expr)

libproj_configuration()

libproj_configure(
  search_path = c(system.file("proj", package = "libproj"),
    getOption("libproj.search_path", NULL)),
  db_path = getOption("libproj.db_path", system.file("proj/proj.db", package =
    "libproj")),
  user_writable_dir = getOption("libproj.user_writable_dir", libproj_temp_dir()),
  network_endpoint = getOption("libproj.network_endpoint", "https://cdn.proj.org"),
  network_enabled = getOption("libproj.network_enabled", FALSE)
)
}
\arguments{
\item{config}{A named \code{list()} with elements used to temporarily override elements of the
current \code{\link[=libproj_configuration]{libproj_configuration()}}.}

\item{expr}{An expression to evaluate with the specified state}

\item{search_path}{A character vector of paths where libproj will
look for resource files (e.g., gridshift, database, init files).
Defaults to the internal database and init files distributed
with the PROJ source.}

\item{db_path}{Independent of \code{search_path}, a character vector of
SQLite databases that may contain updated or alternative
coordinate operations from the default proj.db included in this
package. You must specify at least one database as part of this configuration;
do not rely on \code{search_path} to find this value for you.}

\item{user_writable_dir}{A directory that can safely be written to
by this package. This contains a cache of grid shift files downloaded
from the PROJ CDN at \code{network_endpoint} if using \code{with_libproj_network()}.}

\item{network_endpoint}{A mirror of the PROJ CDN of gridshift files. By default,
this is set to \url{https://cdn.proj.org}.}

\item{network_enabled}{Whether or not to download gridshift files on the fly.
This defaults to \code{FALSE}.}
}
\description{
PROJ configuration
}
\examples{
libproj_version()
libproj_has_libtiff()
libproj_has_libcurl()
libproj_temp_dir()
libproj_configuration()


}
