% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R, R/methods-KernelComputer.R
\docType{class}
\name{KernelComputer-class}
\alias{KernelComputer-class}
\alias{KernelComputer}
\alias{show,KernelComputer-method}
\alias{num_components,KernelComputer-method}
\alias{num_evalpoints,KernelComputer-method}
\alias{num_paramsets,KernelComputer-method}
\alias{component_names,KernelComputer-method}
\title{An S4 class to represent input for kernel matrix computations}
\usage{
\S4method{show}{KernelComputer}(object)

\S4method{num_components}{KernelComputer}(object)

\S4method{num_evalpoints}{KernelComputer}(object)

\S4method{num_paramsets}{KernelComputer}(object)

\S4method{component_names}{KernelComputer}(object)
}
\arguments{
\item{object}{The object for which to call a class method.}
}
\description{
An S4 class to represent input for kernel matrix computations
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(KernelComputer)}: Print a summary about the object.

\item \code{num_components(KernelComputer)}: Get number of components.

\item \code{num_evalpoints(KernelComputer)}: Get number of evaluation points.

\item \code{num_paramsets(KernelComputer)}: Get number of parameter sets.

\item \code{component_names(KernelComputer)}: Get component names.

}}
\section{Slots}{

\describe{
\item{\code{input}}{Common input (for example parameter values).}

\item{\code{K_input}}{Input for computing kernel matrices between data points
(\code{N} x \code{N}). A list.}

\item{\code{Ks_input}}{Input for computing kernel matrices between data and output
points (\code{P} x \code{N}). A list.}

\item{\code{Kss_input}}{Input for computing kernel matrices between output
points (\code{P} x \code{P}). A list, empty if \code{full_covariance=FALSE}.}

\item{\code{comp_names}}{Component names (character vector).}

\item{\code{full_covariance}}{Boolean value determining if this can compute
full predictive covariance matrices (or just marginal variance at
each point).}

\item{\code{no_separate_output_points}}{Boolean value determining if
\code{Ks_input} and \code{Kss_input} are the same thing. Using this
knowledge can reduce unnecessary computations of kernel matrices.}

\item{\code{STREAM}}{external pointer (for calling 'Stan' functions)}
}}

