% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeGradtrunc.R
\name{computeGradtruncSpatioTemporal}
\alias{computeGradtruncSpatioTemporal}
\title{computeGradtruncSpatioTemporal function}
\usage{
computeGradtruncSpatioTemporal(nsims = 100, scale = 1, nis, mu, rootQeigs,
  invrootQeigs, spatial, temporal, bt, cellarea)
}
\arguments{
\item{nsims}{The number of simulations to use in computation of gradient truncation.}

\item{scale}{multiplicative scaling constant, returned value is scale (times) max(gradient over simulations). Default scale is 1.}

\item{nis}{cell counts on the extended grid}

\item{mu}{parameter of latent field, mu}

\item{rootQeigs}{root of eigenvalues of precision matrix of latent field}

\item{invrootQeigs}{reciprocal root of eigenvalues of precision matrix of latent field}

\item{spatial}{spatial at risk interpolated onto grid of requisite size}

\item{temporal}{fitted temporal values}

\item{bt}{vectoer of variances b(delta t) in Brix and Diggle 2001}

\item{cellarea}{cell area}
}
\value{
gradient truncation parameter
}
\description{
\bold{Advanced use only.} A function to compute a gradient truncation parameter for 'spatial only' MALA via simulation. The function
requires an FFT 'grid' to be pre-computed, see \link{fftgrid}.
}
\seealso{
\link{fftgrid}
}

