% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_conditional_independence.R
\name{ci_test}
\alias{ci_test}
\title{Test for conditional independence}
\usage{
ci_test(lg_object, h = function(x) x^2, n_rep = 500, nodes = 100,
  M = NULL, M_sim = 1500, M_corr = 1.5, n_corr = 1.2,
  extend = 0.3, return_time = TRUE)
}
\arguments{
\item{lg_object}{An object of type \code{lg}, as produced by the
\code{lg_main}-function}

\item{h}{The \code{h}-function used in the calculation of the test statistic.
The default value is \code{h(x) = x^2}.}

\item{n_rep}{The number of replicated bootstrap samples}

\item{nodes}{Either the number of equidistant nodes to generate, or a vector
of nodes supplied by the user}

\item{M}{The value for M in the accept-reject algorithm if already known}

\item{M_sim}{The number of replicates to simulate in order to find a value
for M}

\item{M_corr}{Correction factor for M, to be on the safe side}

\item{n_corr}{Correction factor for n_new, so that we mostly will generate
enough observations in the first go}

\item{extend}{How far to extend the grid beyond the extreme data points when
interpolating, in share of the range}

\item{return_time}{Measure how long the test takes to run, and return along
with the test result}
}
\description{
Perform a test for conditional independence between the first two variables
in the data set, given the remaining variables.
}
