% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minmax.R
\name{minmax}
\alias{minmax}
\title{Creating linguistic context directly from values}
\usage{
minmax(x, type = c("ctx3", "ctx5", "ctx3bilat", "ctx5bilat"), ...)
}
\arguments{
\item{x}{A numeric vector to compute the context from}

\item{type}{A type of the context to be returned. Must be one of:
\code{ctx3}, \code{ctx5}, \code{ctx3bilat} or \code{ctx5bilat}}

\item{...}{other parameters to be passed to the appropriate constructor
(\code{\link[=ctx3]{ctx3()}}, \code{\link[=ctx3bilat]{ctx3bilat()}}, \code{\link[=ctx5]{ctx5()}}, and \code{\link[=ctx5bilat]{ctx5bilat()}}) that is called internally.
These values overwrite the defaults computed by \code{minmax} -- see the examples.}
}
\description{
This function creates a context (i.e. an instance of S3 class
\code{\link[=ctx3]{ctx3()}}, \code{\link[=ctx3bilat]{ctx3bilat()}}, \code{\link[=ctx5]{ctx5()}}, or \code{\link[=ctx5bilat]{ctx5bilat()}}) based on values
of the numeric vector \code{x}. In default, the context is based on minimum
and maximum value of \code{x} in the folowing way:
\itemize{
\item \code{ctx3}, \code{ctx5}: low = minimum, high = maximum value of \code{x};
\item \code{ctx3bilat}, \code{ctx5bilat}: negMax = minimum, max = maximum value of \code{x},
origin = mean of minimum and maximum.
}
}
\details{
Other values are computed accordingly to defaults as defined in the constructors
\code{\link[=ctx3]{ctx3()}}, \code{\link[=ctx3bilat]{ctx3bilat()}}, \code{\link[=ctx5]{ctx5()}}, and \code{\link[=ctx5bilat]{ctx5bilat()}}).
}
\examples{
  minmax(0:100)                # returns ctx3: 0, 50, 100
  minmax(0:100, high=80)       # returns ctx3: 0, 40, 80
  minmax(0:100, relCenter=0.4) # returns ctx3: 0, 40, 100
  minmax(0:100, type='ctx5')   # returns ctx5: 0, 25, 50, 75, 100
}
