% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pyrola}
\alias{pyrola}
\title{Demographic Dataset of \emph{Pyrola japonica} and \emph{Pyrola subaphylla}
Populations, in Horizontal Format}
\format{
A data frame with 454 individuals and 57 variables. Each row 
corresponds to an unique individual, and each variable from
\code{sprouted.2015} on refers to the state of the individual in a particular
year.

\describe{
  \item{species}{String denoting which of the two species the individual
  belongs to.}
  \item{population}{Integer denoting whcih population the individual belongs
  to. Synonymous with species in this dataset.}
  \item{id}{A numeric variable giving a unique number to each 
  individual within each species. Note that numbers are reused among the two
  species.}
  \item{sprouted.2015}{A binomial indicating whether the individual had
  living aboveground tissue observable in the 2015 census.}
  \item{lvs.num.2015}{Number of leaves in 2015.}
  \item{lvs.lng.2015}{Length of largest leaf in 2015.}
  \item{lvs.wdt.2015}{Width of largest leaf in 2015.}
  \item{inf.num.2015}{Number of inflorescences in 2015.}
  \item{inf.lng.tot.2015}{Summed inflorescence length in 2015.}
  \item{flo.tot.2015}{Number of flowers in 2015.}
  \item{frt.tot.2015}{Number of fruits in 2015.}
  \item{sprouted.2016}{A binomial indicating whether the individual had
  living aboveground tissue observable in the 2016 census.}
  \item{lvs.num.2016}{Number of leaves in 2016.}
  \item{lvs.lng.2016}{Length of largest leaf in 2016.}
  \item{lvs.wdt.2016}{Width of largest leaf in 2016.}
  \item{inf.num.2016}{Number of inflorescences in 2016.}
  \item{inf.lng.tot.2016}{Summed inflorescence length in 2016.}
  \item{flo.tot.2016}{Number of flowers in 2016.}
  \item{frt.tot.2016}{Number of fruits in 2016.}
  \item{sprouted.2017}{A binomial indicating whether the individual had
  living aboveground tissue observable in the 2017 census.}
  \item{lvs.num.2017}{Number of leaves in 2017.}
  \item{lvs.lng.2017}{Length of largest leaf in 2017.}
  \item{lvs.wdt.2017}{Width of largest leaf in 2017.}
  \item{inf.num.2017}{Number of inflorescences in 2017.}
  \item{inf.lng.tot.2017}{Summed inflorescence length in 2017.}
  \item{flo.tot.2017}{Number of flowers in 2017.}
  \item{frt.tot.2017}{Number of fruits in 2017.}
  \item{sprouted.2018}{A binomial indicating whether the individual had
  living aboveground tissue observable in the 2018 census.}
  \item{lvs.num.2018}{Number of leaves in 2018.}
  \item{lvs.lng.2018}{Length of largest leaf in 2018.}
  \item{lvs.wdt.2018}{Width of largest leaf in 2018.}
  \item{inf.num.2018}{Number of inflorescences in 2018.}
  \item{inf.lng.tot.2018}{Summed inflorescence length in 2018.}
  \item{flo.tot.2018}{Number of flowers in 2018.}
  \item{frt.tot.2018}{Number of fruits in 2018.}
  \item{sprouted.2019}{A binomial indicating whether the individual had
  living aboveground tissue observable in the 2019 census.}
  \item{lvs.num.2019}{Number of leaves in 2019.}
  \item{lvs.lng.2019}{Length of largest leaf in 2019.}
  \item{lvs.wdt.2019}{Width of largest leaf in 2019.}
  \item{inf.num.2019}{Number of inflorescences in 2019.}
  \item{inf.lng.tot.2019}{Summed inflorescence length in 2019.}
  \item{flo.tot.2019}{Number of flowers in 2019.}
  \item{frt.tot.2019}{Number of fruits in 2019.}
  \item{sprouted.2020}{A binomial indicating whether the individual had
  living aboveground tissue observable in the 2020 census.}
  \item{lvs.num.2020}{Number of leaves in 2020.}
  \item{lvs.lng.2020}{Length of largest leaf in 2020.}
  \item{lvs.wdt.2020}{Width of largest leaf in 2020.}
  \item{inf.num.2020}{Number of inflorescences in 2020.}
  \item{inf.lng.tot.2020}{Summed inflorescence length in 2020.}
  \item{flo.tot.2020}{Number of flowers in 2020.}
  \item{frt.tot.2020}{Number of fruits in 2020.}
}
}
\source{
Shefferson, R.P., K. Shutoh, and K. Suetsugu. \emph{In review}.
Vegetative dormancy and the evolution of mycoheterotrophy in sister
\emph{Pyrola} species. \emph{Journal of Ecology}.
}
\usage{
data(pyrola)
}
\description{
A dataset containing the states and fates of \emph{Pyrola japonica} and
\emph{Pyrola subaphylla}, family Ericaceae, from populations in the vicinity
of Mt. Bandai, Fukushima Prefecture, Japan, resulting from monitoring that
occurred annually between 2015 and 2020.
}
\examples{
\donttest{
data(pyrola)

pyrola$species <- as.factor(pyrola$species)
pyrola$population <- as.factor(pyrola$population)
jreg <- pyrola[which(pyrola$population == 1),]
stagevec_jp <- c("P1", "Sdl", "Dorm", "V0nr", "V1nr", "V2nr", "V3nr", "V4nr",
  "V0r", "V1r", "V2r", "V3r", "V4r")
sizeavec_jp <- c(0, 0, 0, 0, 1, 2, 3, 7, 0, 1, 2, 3, 7)
sizeahbin_jp <- c(0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 3.5, 0.5, 0.5, 0.5, 0.5,
  3.5)
repvec_jp <- c(0, 0, 0, 0, rep(0, 4), rep(1, 5))
propvec_jp <- c(1, rep(0, 12))
immvec_jp <- c(1, 1, rep(0, 11))
matvec_jp <- c(0, 0, rep(1, 11))
obsvec_jp <- c(0, 0, 0, rep(1, 10))
indata_jp <- c(0, 0, rep(1, 11))
comments_jp <- c("protocorm", "seedling", "dormant adult", "stump", "1lf nr",
  "2lf nr", "3lf nr", "4+lf nr", "0lf r", "1lf r", "2lf r", "3lf r",
  "4+lf r")
jp_frame <- sf_create(sizes = sizeavec_jp, stagenames = stagevec_jp,
  binhalfwidth = sizeahbin_jp, repstatus = repvec_jp, obsstatus = obsvec_jp,
  indataset = indata_jp, propstatus = propvec_jp, immstatus = immvec_jp,
  matstatus = matvec_jp, comments = comments_jp)
  
jhfv <- verticalize3(data = jreg, noyears = 6, firstyear = 2015,
  individcol = "id", blocksize = 8, sizeacol = "lvs.num.2015",
  obsacol = "sprouted.2015", repstracol = "flo.tot.2015",
  repstrbcol = "frt.tot.2015", fecacol = "flo.tot.2015",
  fecbcol = "frt.tot.2015", NAas0 = TRUE, stagesize = "sizea",
  stageassign = jp_frame)
  
jp_models_ah <- modelsearch(data = jhfv, stageframe = jp_frame,
  suite = "full", vitalrates = c("surv", "obs", "size", "repst", "fec"),
  fec = c("fec3added", "fec2added"), sizedist = "poisson",
  fecdist = "negbin", fec.trunc = TRUE, historical = FALSE,
  quiet = "partial")
jp_germ <- 0.90

jp_supp2 <- supplemental(stage3 = c("Sdl", "Dorm", "V0nr", "V1nr", "P1", "Sdl"), 
  stage2 = c("P1", "Sdl", "Sdl", "Sdl", "rep", "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, NA),
  givenrate = c(0.25, 0.35, 0.10, 0.10, NA, NA), # 0.345, 0.054
  multiplier = c(NA, NA, NA, NA, jp_germ * 0.5, jp_germ * 0.5),
  type = c(1, 1, 1, 1, 3, 3), stageframe = jp_frame, historical = FALSE)

jp_ahmpm <- flefko2(year = "all", stageframe = jp_frame,
  supplement = jp_supp2, modelsuite = jp_models_ah, data = jhfv,
  err_check = TRUE)

lambda3(jp_ahmpm)
}
}
\keyword{datasets}
