% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{aflefko2}
\alias{aflefko2}
\title{Create Function-based Ahistorical Age x Stage Matrix Projection Model}
\usage{
aflefko2(
  year = "all",
  patch = "all",
  stageframe,
  supplement = NULL,
  repmatrix = NULL,
  overwrite = NULL,
  data = NULL,
  modelsuite = NULL,
  surv_model = NULL,
  obs_model = NULL,
  size_model = NULL,
  sizeb_model = NULL,
  sizec_model = NULL,
  repst_model = NULL,
  fec_model = NULL,
  jsurv_model = NULL,
  jobs_model = NULL,
  jsize_model = NULL,
  jsizeb_model = NULL,
  jsizec_model = NULL,
  jrepst_model = NULL,
  jmatst_model = NULL,
  paramnames = NULL,
  inda = NULL,
  indb = NULL,
  indc = NULL,
  surv_dev = 0,
  obs_dev = 0,
  size_dev = 0,
  sizeb_dev = 0,
  sizec_dev = 0,
  repst_dev = 0,
  fec_dev = 0,
  jsurv_dev = 0,
  jobs_dev = 0,
  jsize_dev = 0,
  jsizeb_dev = 0,
  jsizec_dev = 0,
  jrepst_dev = 0,
  jmatst_dev = 0,
  density = NA,
  repmod = 1,
  random.inda = FALSE,
  random.indb = FALSE,
  random.indc = FALSE,
  final_age = NA,
  continue = TRUE,
  prebreeding = TRUE,
  negfec = FALSE,
  ipm_method = "CDF",
  reduce = FALSE,
  err_check = FALSE,
  exp_tol = 700,
  theta_tol = 1e+08
)
}
\arguments{
\item{year}{A variable corresponding to the observation occasion, or a set
of such values, given in values associated with the year term used in linear 
model development. Defaults to \code{"all"}, in which case matrices will be
estimated for all occasions.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Defaults to \code{"all"}, but can also be set to specific
patch names or a vector thereof.}

\item{stageframe}{An object of class \code{stageframe}. These objects are
generated by function \code{\link{sf_create}()}, and include information on
the size, observation status, propagule status, reproduction status,
immaturity status, maturity status, stage group, size bin widths, and other
key characteristics of each ahistorical stage.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for survival and fecundity.
This data frame should be produced using the \code{\link{supplemental}()}
function. Can be used in place of or in addition to an overwrite table (see 
\code{overwrite} below) and a reproduction matrix (see \code{repmatrix}
below).}

\item{repmatrix}{An optional reproduction matrix. This matrix is composed
mostly of \code{0}s, with non-zero entries acting as element identifiers and
multipliers for fecundity (with \code{1} equaling full fecundity). If left
blank, and no \code{supplement} is provided, then \code{aflefko2()} will
assume that all stages marked as reproductive produce offspring at 1x that of
estimated fecundity, and that offspring production will yield the first stage
noted as propagule or immature. Must be the dimensions of an ahistorical
stage-based matrix.}

\item{overwrite}{An optional data frame developed with the
\code{\link{overwrite}()} function describing transitions to be overwritten
either with given values or with other estimated transitions. Note that this
function supplements overwrite data provided in \code{supplement}.}

\item{data}{The historical vertical demographic data frame used to estimate
vital rates (class \code{hfvdata}), which is required to initialize times and
patches properly. Variable names should correspond to the naming conventions
in \code{\link{verticalize3}()} and \code{\link{historicalize3}()}.}

\item{modelsuite}{A \code{lefkoMod} object holding the vital rate models and
associated metadata. If given, then \code{surv_model}, \code{obs_model}, 
\code{size_model}, \code{sizeb_model}, \code{sizec_model},
\code{repst_model}, \code{fec_model}, \code{jsurv_model}, \code{jobs_model},
\code{jsize_model}, \code{jsizeb_model}, \code{jsizec_model},
\code{jrepst_model}, \code{jmatst_model}, and \code{paramnames} are not
required. No models should include size or reproductive status in occasion
\emph{t}-1. Although this is optional input, it is recommended, and without
it all vital rate model inputs (named \code{XX_model}) are required.}

\item{surv_model}{A linear model predicting survival probability. This can 
be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{obs_model}{A linear model predicting sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{size_model}{A linear model predicting primary size. This can be a model
of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{sizeb_model}{A linear model predicting secondary size. This can be a
model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{sizec_model}{A linear model predicting tertiary size. This can be a
model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{repst_model}{A linear model predicting reproduction probability. This 
can be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
only the impacts of occasion \emph{t}.}

\item{fec_model}{A linear model predicting fecundity. This can be a model of
class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl}, \code{vglm},
\code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is provided. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jsurv_model}{A linear model predicting juvenile survival probability.
This can be a model of class \code{glm} or \code{glmer}, and requires a
predicted binomial variable under a logit link. Ignored if \code{modelsuite}
is provided. This model must have been developed in a modeling exercise
testing only the impacts of occasion \emph{t}.}

\item{jobs_model}{A linear model predicting juvenile sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jsize_model}{A linear model predicting juvenile primary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jsizeb_model}{A linear model predicting juvenile secondary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jsizec_model}{A linear model predicting juvenile tertiary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing only the impacts of occasion \emph{t}.}

\item{jrepst_model}{A linear model predicting reproduction probability of a 
mature individual that was immature in time \emph{t}. This can be a model
of class \code{glm} or \code{glmer}, and requires a predicted binomial
variable under a logit link. Ignored if \code{modelsuite} is provided. This
model must have been developed in a modeling exercise testing only the
impacts of occasion \emph{t}.}

\item{jmatst_model}{A linear model predicting maturity probability of an 
individual that was immature in time \emph{t}. This can be a model of class
\code{glm} or \code{glmer}, and requires a predicted binomial variable under
a logit link. Ignored if \code{modelsuite} is provided. This model must have
been developed in a modeling exercise testing only the impacts of occasion
\emph{t}.}

\item{paramnames}{A data frame with three columns, the first describing all
terms used in linear modeling, the second (must be called \code{mainparams})
giving the general model terms that will be used in matrix creation, and the
third showing the equivalent terms used in modeling (must be named
\code{modelparams}). Function \code{\link{create_pm}()} can be used to
create a skeleton \code{paramnames} object, which can then be edited. Only
required if \code{modelsuite} is not supplied.}

\item{inda}{Can be a single value to use for individual covariate \code{a}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{indb}{Can be a single value to use for individual covariate \code{b}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{indc}{Can be a single value to use for individual covariate \code{c}
in all matrices, a pair of values to use for times \emph{t} and \emph{t}-1 in
historical matrices, or a vector of such values corresponding to each
occasion in the dataset. Defaults to \code{NULL}.}

\item{surv_dev}{A numeric value to be added to the y-intercept in the linear
model for survival probability. Defaults to \code{0}.}

\item{obs_dev}{A numeric value to be added to the y-intercept in the linear
model for observation probability. Defaults to \code{0}.}

\item{size_dev}{A numeric value to be added to the y-intercept in the linear
model for primary size. Defaults to \code{0}.}

\item{sizeb_dev}{A numeric value to be added to the y-intercept in the linear
model for secondary size. Defaults to \code{0}.}

\item{sizec_dev}{A numeric value to be added to the y-intercept in the linear
model for tertiary size. Defaults to \code{0}.}

\item{repst_dev}{A numeric value to be added to the y-intercept in the linear
model for probability of reproduction. Defaults to \code{0}.}

\item{fec_dev}{A numeric value to be added to the y-intercept in the linear
model for fecundity. Defaults to \code{0}.}

\item{jsurv_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile survival probability. Defaults to \code{0}.}

\item{jobs_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile observation probability. Defaults to \code{0}.}

\item{jsize_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile primary size. Defaults to \code{0}.}

\item{jsizeb_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile secondary size. Defaults to \code{0}.}

\item{jsizec_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile tertiary size. Defaults to \code{0}.}

\item{jrepst_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile reproduction probability. Defaults to \code{0}.}

\item{jmatst_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile maturity probability. Defaults to \code{0}.}

\item{density}{A numeric value indicating density value to use to propagate
matrices. Only needed if density is an explanatory term used in one or more
vital rate models. Defaults to \code{NA}.}

\item{repmod}{A scalar multiplier of fecundity. Defaults to \code{1}.}

\item{random.inda}{A logical value denoting whether to treat individual
covariate \code{a} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indb}{A logical value denoting whether to treat individual
covariate \code{b} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random.indc}{A logical value denoting whether to treat individual
covariate \code{c} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{final_age}{The final age to model in the matrix, where the first age
will be age 0. Defaults to the maximum age in the dataset.}

\item{continue}{A logical value designating whether to allow continued
survival of individuals past the final age noted in the stageframe, using the 
demographic characteristics of the final age. Defaults to \code{TRUE}.}

\item{prebreeding}{A logical value indicating whether the life history model
is a pre-breeding model. Defaults to \code{TRUE}.}

\item{negfec}{A logical value denoting whether fecundity values estimated to
be negative should be reset to \code{0}. Defaults to \code{FALSE}.}

\item{ipm_method}{A string indicating what method to use to estimate size
transition probabilities, if size is treated as continuous. Options include:
\code{"midpoint"}, which utilizes the midpoint method; and \code{"CDF"},
which uses the cumulative distribution function. Defaults to \code{"CDF"}.}

\item{reduce}{A logical value denoting whether to remove age-stages
associated solely with \code{0} transitions. These are only removed in cases
where the associated row and column sums in ALL matrices estimated equal 0. 
Defaults to \code{FALSE}.}

\item{err_check}{A logical value indicating whether to append matrices of
vital rate probabilities associated with each matrix to the \code{lefkoMat}
object generated. These matrices are developed internally and can be used for
error checking (see element \code{out} in Value section below for details).
Defaults to \code{FALSE}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}
}
\value{
If all inputs are properly formatted, then this function will return
an object of class \code{lefkoMat}, which is a list that holds the matrix
projection model and all of its metadata. The structure has the following
elements:

\item{A}{A list of full projection matrices in order of sorted patches and
occasions. All matrices output in R's \code{matrix} class.}
\item{U}{A list of survival transition matrices sorted as in \code{A}. All 
matrices output in R's \code{matrix} class.}
\item{F}{A list of fecundity matrices sorted as in \code{A}. All matrices 
output in R's \code{matrix} class.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical stages
used to create historical stage pairs. Set to \code{NA} for age-by-stage
MPMs.}
\item{agestages}{A data frame showing the stage number and stage name
corresponding to \code{ahstages}, as well as the associated age, of each
row in each age-by-stage matrix.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages, in the form of a modified stageframe that includes
status as an entry stage through reproduction.}
\item{labels}{A data frame giving the patch and year of each matrix in order.
In \code{aflefko2()}, only one population may be analyzed at once.}
\item{matrixqc}{A short vector describing the number of non-zero elements
in \code{U} and \code{F} matrices, and the number of annual matrices.}
\item{modelqc}{This is the \code{qc} portion of the modelsuite input.}
\item{prob_out}{An optional element only added if \code{err_check = TRUE}.
This is a list of vital rate probability matrices, with 7 columns in the
order of survival, observation probability, reproduction probability, primary
size transition probability, secondary size transition probability, tertiary
size transition probability, and probability of juvenile transition to
maturity.}
\item{allstages}{An optional element only added if \code{err_check = TRUE}.
This is a data frame giving the values used to determine each matrix element
capable of being estimated.}
}
\description{
Function \code{aflefko2()} returns ahistorical age x stage MPMs corresponding
to the patches and occasions given, including the associated component
transition and fecundity matrices, data frames detailing the characteristics
of ahistorical stages and the exact age-stage combinations corresponding to
rows and columns in estimated matrices, and a data frame characterizing the
patch and occasion combinations corresponding to these matrices.
}
\section{Notes}{

Unlike \code{\link{rlefko2}()}, \code{\link{rlefko3}()},
\code{\link{arlefko2}()}, and \code{\link{rleslie}()}, this function does not
currently distinguish populations. Users wishing to use the same vital rate
models across populations should label them as patches (though we do not
advise this approach, as populations should typically be treated as
statistically independent).

This function will yield incorrect estimates if the models utilized
incorporate state in occasion \emph{t}-1. Only use models developed testing
for ahistorical effects.

The default behavior of this function is to estimate fecundity with regards
to transitions specified via associated fecundity multipliers in either
\code{supplement} or \code{repmatrix}. If both of these fields are left
empty, then fecundity will be estimated at full for all transitions leading
from reproductive stages to immature and propagule stages. However, if a
\code{supplement} is provided and a \code{repmatrix} is not, or if
\code{repmatrix} is set to 0, then only fecundity transitions noted in the
supplement will be set to non-zero values. To use the default behavior of
setting all reproductive stages to reproduce at full fecundity into immature
and propagule stages but also incorporate given or proxy
survival transitions, input those given and proxy transitions through the
\code{overwrite} option.

The reproduction matrix (field \code{repmatrix}) may only be supplied as
ahistorical. If provided as historical, then \code{aflefko2()} will fail and
produce an error.

Stageframes used in this function should include ages for minimum and maximum
age for each stage. \code{NA}s are treated as \code{0}s in minimum age, and
as \code{final_age} for maximum age.

Users may at times wish to estimate MPMs using a dataset incorporating
multiple patches or subpopulations, but without discriminating between those
patches or subpopulations. Should the aim of analysis be a general MPM that
does not distinguish these patches or subpopulations, the
\code{modelsearch()} run should not include patch terms.

Input options including multiple variable names must be entered in the order
of variables in occasion \emph{t}+1 and \emph{t}. Rearranging the order will
lead to erroneous calculations, and may lead to fatal errors.

Care should be taken to match the random status of year and patch to the
states of those variables within the \code{modelsuite}. If they do not match,
then they will be treated as zeroes in vital rate estimation.

The \code{ipm_method} function gives the option of using two different means
of estimating the probability of size transition. The midpoint method
(\code{"midpoint"}) refers to the method in which the probability is
estimated by first estimating the probability associated with transition from
the exact size at the midpoint of the size class using the corresponding
probability density function, and then multiplying that value by the bin
width of the size class. Doak et al. 2021 (Ecological Monographs) noted that
this method can produce biased results, with total size transitions
associated with a specific size not totaling to 1.0 and even specific size
transition probabilities capable of being estimated at values greater than
1.0. The alternative and default method, \code{"CDF"}, uses the corresponding
cumulative density function to estimate the probability of size transition as
the cumulative probability of size transition at the greater limit of the
size class minus the cumulative probability of size transition at the lower
limit of the size class. The latter method avoids this bias. Note, however,
that both methods are exact and unbiased for the Poisson and negative
binomial distributions.

Under the Gaussian and gamma size distributions, the number of estimated
parameters may differ between the two \code{ipm_method} settings. Because
the midpoint method has a tendency to incorporate upward bias in the
estimation of size transition probabilities, it is more likely to yield non-
zero values when the true probability is extremely close to 0. This will
result in the \code{summary.lefkoMat} function yielding higher numbers of
estimated parameters than the \code{ipm_method = "CDF"} yields in some cases.

Using the \code{err_check} option will produce a matrix of 7 columns, each
characterizing a different vital rate. The product of each row yields an
element in the associated \code{U} matrix. The number and order of elements
in each column of this matrix matches the associated matrix in column vector
format. Use of this option is generally for the purposes of debugging code.
}

\examples{
\donttest{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r",
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
minima <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
maxima <- c(NA, 1, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
  NA, NA, NA, NA, NA)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector, minage = minima, maxage = maxima)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframeln,
  stagesize = "sizea", censorcol = "Missing1988", censorkeep = NA,
  NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathmodelsln2 <- modelsearch(lathvertln, historical = FALSE,
  approach = "mixed", suite = "main",
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson",
  indiv = "individ", patch = "patchid", year = "year2", age = "obsage",
  year.as.random = TRUE, patch.as.random = TRUE, show.model.tables = TRUE,
  quiet = TRUE)

# Here we use supplemental() to provide overwrite and reproductive info
lathsupp2 <- supplemental(stage3 = c("Sd", "Sdl", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "rep", "rep"),
  givenrate = c(0.345, 0.054, NA, NA),
  multiplier = c(NA, NA, 0.345, 0.054),
  type = c(1, 1, 3, 3), stageframe = lathframeln, historical = FALSE)

lathmat2age <- aflefko2(year = "all", patch = "all", 
  stageframe = lathframeln, modelsuite = lathmodelsln2, data = lathvertln,
  supplement = lathsupp2, final_age = 3, continue = TRUE, reduce = FALSE)

summary(lathmat2age)
}
}
\seealso{
\code{\link{flefko3}()}

\code{\link{flefko2}()}

\code{\link{fleslie}()}

\code{\link{arlefko2}()}

\code{\link{rlefko3}()}

\code{\link{rlefko2}()}

\code{\link{rleslie}()}
}
