% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{sf_distrib}
\alias{sf_distrib}
\title{Test for overdispersion and zero inflation in size and fecundity}
\usage{
sf_distrib(
  data,
  size3 = NA,
  size2 = NA,
  obs3 = NA,
  fec = NA,
  repst = NA,
  zisize = TRUE,
  zifec = TRUE
)
}
\arguments{
\item{data}{A historical vertical data file, which is a data frame of class
\code{hfvdata}.}

\item{size3}{The name or column number of the variable corresponding to size
in time *t+1*.}

\item{size2}{The name or column number of the variable corresponding to size
in time *t*. This term is required for both size and fecundity tests.}

\item{obs3}{The name or column number of the variable corresponding to
observation status in time *t+1*. This should be used if observation status
will be used as a vital rate to absorb states of size = 0.}

\item{fec}{The name or column number of the variable corresponding to
fecundity. The name of the variable should correspond to the proper time,
either time *t* or time *t*-1.}

\item{repst}{The name or column number of the variable corresponding to
reproductive status in time *t*. Required if fecundity distribution will be
tested.}

\item{zisize}{A logical value indicating whether to conduct a test of zero
inflation in size. Defaults to TRUE.}

\item{zifec}{A logical value indicating whether to conduct a test of zero
inflation in fecundity. Defaults to TRUE.}
}
\value{
Produces text describing the degree and significance of difference
from expected dispersion, and the degree and significance of zero inflation.
The tests are chi-squared score tests based on the expectations of 
mean = variance, and 0s as abundant as predicted by the value of lambda
estimated from the dataset. See van der Broek (1995) for more details.
}
\description{
Function \code{sf_distrib} takes a historically formatted vertical data as
input and tests whether size and fecundity data are dispersed according to a
Poisson distribution (where mean = variance), and whether the number of 0s
exceeds expectations.
}
\section{Notes}{

This function subsets the data in the same way as \code{\link{modelsearch}()}
before testing underlying distributions, making the output much more
appropriate than a simple analysis of size and fecundity variables in
\code{data}.

The specific test used for overdispersion is a chi-squared test of the
dispersion parameter estimated using a generalized linear model predicting
the response given size in time *t*, under a quasi-Poisson distribution.

The specific test used for zero-inflation is the chi-squared test presented
in van der Broek (1995).
}

\examples{
# Lathyrux example
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r",
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

# The following will only test fecundity, since size is Gaussian.
# Zero-inflation will not be assessed in this example, since 0 values in
# fecundity have been excluded in the life history model.

sf_distrib(lathvertln, size2 = "sizea2", fec = "feca2",
  repst = "repstatus2", zifec = FALSE)

# Cypripedium example
rm(list=ls(all=TRUE))

data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

sf_distrib(cypraw_v1, size2 = "size2added", fec = "feca2",
  repst = "repstatus2", zisize = FALSE)

}
